/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "location.h"
#include "typecheck.h"
#include "strstream2string.h"
#include "trfalse.h"

/*******************************************************************\

Function: typecheckt::err_location

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void typecheckt::err_location(const irept &irep)
 {
  const irept &location=find_location((const exprt &)irep);
  if(!location.is_nil())
    err << location_string(location) << ": ";
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool typecheckt::typecheck_main()
 {
  bool result=FALSE;

  try
   {
    typecheck();
   }

  catch(int e)
   {
    result=TRUE;
   }

  catch(const char *e)
   {
    err << e << std::endl;
    result=TRUE;
   }

  catch(const std::string &e)
   {
    err << e << std::endl;
    result=TRUE;
   }

  return result;
 }
