/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_SYMBOL_H
#define CPROVER_SYMBOL_H

#include "expr.h"
#include "trfalse.h"

class symbolt
 {
 public:
  typet type;
  exprt value;
  std::string name;
  std::string module;
  std::string base_name;
  std::string mode;
  
  unsigned ordering;
  
  // global use
  bool theorem, axiom, is_type, is_macro, is_exported,
       is_input, is_output;
       
  // PVS
  bool is_actual, free_var;
  
  // ANSI-C
  bool lvalue, is_static, is_extern, is_volatile;
       
  symbolt()
   { theorem=lvalue=is_static=is_extern=axiom=free_var=
     is_type=is_actual=is_macro=is_exported=
     is_volatile=is_input=is_output=FALSE;
     ordering=0; }
 };

#include <list>
 
typedef std::list<symbolt> symbol_listt;

#define forall_symbol_list(it, expr) \
  for(symbol_listt::const_iterator it=(expr).begin(); \
      it!=(expr).end(); it++)

typedef std::list<const symbolt *> symbolptr_listt;

#define forall_symbolptr_list(it, list) \
  for(symbolptr_listt::const_iterator it=(list).begin(); \
      it!=(list).end(); it++)

#define Forall_symbolptr_list(it, list) \
  for(symbolptr_listt::iterator it=(list).begin(); \
      it!=(list).end(); it++)

#endif
