/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_SIMPLIFY_H
#define CPROVER_SIMPLIFY_H

//
// simplify a sequent / expression
//
// true: did nothing
// false: simplified something
//

#include "h_sequent.h"

#include <hash_set.h>
#include <hash_map.h>
#include <map>

class constant_propagationt
 {
 public:
  bool constant_propagation(h_sequentt &sequent);

  bool apply_constants(exprt &expr);
  bool apply_bool(exprt &expr, bool premise, bool claim);
  bool apply_bool(exprt &expr, bool premise);

 protected:
  typedef std::hash_set<exprt, irep_hash> sett;
  typedef std::hash_map<exprt, exprt, irep_hash> mapt;

  sett bool_is_true, bool_is_false;
  mapt constants;

  void collect(exprt &expr, bool premise);

  void clean_protected(exprt &expr);

  bool collect_node(const exprt &expr);
 };

class simplify_implt
 {
 public:
  bool simplify_if;
  bool constant_propagation;

  bool sort_operands(exprt::operandst &operands);
  bool simplify_typecast(exprt &expr);
  bool simplify_multiplication(exprt &expr);
  bool simplify_division(exprt &expr);
  bool simplify_modulo(exprt &expr);
  bool simplify_addition_substraction(exprt &expr);
  bool simplify_if_implies(exprt &expr, const exprt &cond, bool truth, bool &new_truth);
  bool simplify_if_recursive(exprt &expr, const exprt &cond, bool truth);
  bool simplify_if_conj(exprt &expr, const exprt &cond);
  bool simplify_if_disj(exprt &expr, const exprt &cond);
  bool simplify_if_branch(exprt &trueexpr, exprt &falseexpr, const exprt &cond);
  bool simplify_if_cond(exprt &expr);
  bool simplify_if_main(exprt &expr);
  bool simplify_switch(exprt &expr);
  bool simplify_boolean(exprt &expr);
  bool simplify_inequality(exprt &expr);
  bool zero_compare(exprt &expr, unsigned side);
  bool simplify_relation(exprt &expr);
  bool simplify_lambda(exprt &expr);
  bool simplify_index(exprt &expr);
  bool sort_and_join(exprt &expr);
  bool simplify_unary_minus(exprt &expr);
  
  virtual bool do_constant_propagation(h_sequentt &sequent);
  virtual bool simplify_node(exprt &expr);
  virtual bool simplify(exprt &expr);
  virtual bool simplify(h_sequentt &sequent);

  simplify_implt()
   {
    simplify_if=TRUE;
    constant_propagation=TRUE;
   }
 };

bool simplify(exprt &expr);

bool simplify(h_sequentt &sequent, bool constant_propagation,
              bool simplify_if,
              const fnumst &fnums);
              
bool simplify(h_sequentt &sequent, bool constant_propagation,
              bool simplify_if);

bool sort_and_join(const std::string &id, const std::string &type_id);

#endif
