/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_SEQUENT_H

#define CPROVER_SEQUENT_H

//
// a Gentzen sequent
//

#include <set>
#include <list>
#include "expr.h"
#include "trfalse.h"
#include "context.h"

typedef class std::set<std::string> lablest;

typedef std::string fnumt; 
typedef std::list<fnumt> fnumst;

class formulat: public exprt
 {
 public:
  formulat(const exprt &expr): exprt(expr) { changed=TRUE; match=FALSE; }
  formulat(): exprt() { changed=TRUE; match=FALSE; }
  void swap(formulat &formula);
  void swap(exprt &expr);
  
  lablest labels;
  bool changed, match;

  virtual bool match_fnum(const fnumt &pattern, int fnum) const;
  virtual bool match_fnum(const fnumst &fnums, int fnum) const;
 };

class all_formulaet: public fnumst
 {
 public:
  all_formulaet() { push_back("*"); }
 } extern all_formulae;

typedef std::list<formulat> formulaet;

#define forall_formulae(it, expr) \
  for(formulaet::const_iterator it=(expr).begin(); \
      it!=(expr).end(); it++)
 
#define Forall_formulae(it, expr) \
  for(formulaet::iterator it=(expr).begin(); \
      it!=(expr).end(); it++)
 
void formulae_to_expr_list(const formulaet &formulae, std::vector<exprt> &expr);
void expr_list_to_formulae(const std::vector<exprt> &expr, formulaet &formulae);
void formula_to_sequent_expr(const formulat &formula, exprt &expr);
void formula_from_expr(const exprt &expr, formulaet &formulae);

class sequentt
 {
 public:
  std::string comment;
  std::string mode;
  irept location;

  formulaet premise, claim;
  symbolst symbols;  
  
  void add_symbol(const symbolt &symbol)
   {
    symbols.insert(std::pair<std::string, symbolt>(symbol.name, symbol));
   }
  
  virtual void add_premise(const formulat &formula);
  virtual void move_to_premise(formulat &formula);
  virtual void move_to_premise(exprt &expr);
  virtual void add_claim(const formulat &formula);
  virtual void add_premise(const formulaet &formulae);
  virtual void add_claim(const formulaet &formulae);
  virtual void move_to_claim(formulat &formula);
  virtual void move_to_claim(exprt &expr);
  virtual void from_expr(const exprt &expr);
  virtual void to_expr(exprt &expr, bool full) const;
  virtual bool is_true() const;
  virtual void make_true();
  virtual void make_false();
  virtual void swap(sequentt &sequent);
  virtual void clear();

  virtual void set_match();
  virtual void reset_match();
  virtual void match_fnum(const fnumst &fnums);
  
  virtual void reset_changed();
  virtual void set_changed();
  
  sequentt() { location.make_nil(); }
  virtual ~sequentt() { }
  
 protected:
  void get_symbols(const irept &irep);
 };

#endif
