/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "i2string.h"
#include "sequent.h"
#include "trfalse.h"

all_formulaet all_formulae;

/*******************************************************************\

Function: formulat::swap

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void formulat::swap(formulat &formula)
 {
  labels.swap(formula.labels);
  exprt::swap(formula);

  bool tmp;

  tmp=formula.changed;
  formula.changed=changed;
  changed=tmp;

  tmp=formula.match;
  formula.match=match;
  match=tmp;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void formulat::swap(exprt &expr)
 {
  exprt::swap(expr);

  labels.clear();
  changed=TRUE;
  match=FALSE;
 }

/*******************************************************************\

Function: sequentt::add_premise

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::add_premise(const formulat &formula)
 {
  premise.insert(premise.begin(), formula);
 }

/*******************************************************************\

Function: sequentt::move_to_premise

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::move_to_premise(formulat &formula)
 {
  formulat tmp;
  premise.insert(premise.begin(), tmp);
  premise.front().swap(formula);
 }

/*******************************************************************\

Function: sequentt::move_to_premise

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::move_to_premise(exprt &expr)
 {
  formulat tmp;
  premise.insert(premise.begin(), tmp);
  premise.front().swap(expr);
 }

/*******************************************************************\

Function: sequentt::add_premise

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::add_premise(const formulaet &formulae)
 {
  forall_formulae(it, formulae)
    add_premise(*it);
 }

/*******************************************************************\

Function: sequentt::add_claim

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::add_claim(const formulat &formula)
 {
  claim.insert(claim.begin(), formula);
 }

/*******************************************************************\

Function: sequentt::move_to_claim

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::move_to_claim(formulat &formula)
 {
  formulat tmp;
  claim.insert(claim.begin(), tmp);
  claim.front().swap(formula);
 }

/*******************************************************************\

Function: sequentt::move_to_claim

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::move_to_claim(exprt &expr)
 {
  formulat tmp;
  claim.insert(claim.begin(), tmp);
  claim.front().swap(expr);
 }

/*******************************************************************\

Function: sequentt::add_claim

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::add_claim(const formulaet &formulae)
 {
  forall_formulae(it, formulae)
    add_premise(*it);
 }

/*******************************************************************\

Function: sequentt::to_expr

  Inputs:

 Outputs:

 Purpose: convert sequent to expression

\*******************************************************************/

void sequentt::to_expr(exprt &expr, bool full) const
 {
  expr=(exprt &)nil_rep;

  expr.type().id="bool";

  if(full)
   {
    expr.id="sequent";

     {
      exprt premise_op;
      premise_op.id="premise";

      forall_formulae(it, premise)
        formula_to_sequent_expr(*it, premise_op);

      expr.move_to_operands(premise_op);
     }

     {
      exprt claim_op;
      claim_op.id="claim";

      forall_formulae(it, claim)
        formula_to_sequent_expr(*it, claim_op);

      expr.move_to_operands(claim_op);
     }

    // comment

    if(comment!="") expr.set("#comment", comment);

    // location

    if(!location.is_nil()) expr.set("#location", location);

    // mode

    if(mode!="") expr.set("#mode", mode);

    // symbol list

    irept &symbols_expr=expr.add("symbols");

    forall_symbols(it, symbols)
     {
      exprt expr;
      expr.type()=it->second.type;
      symbols_expr.set(it->second.name, expr);
     }
   }
  else
   {
    if(premise.empty())
     {
      if(claim.empty())
        expr.make_false();
      else if(claim.size()==1)
        expr=claim.front();
      else
       {
        expr.id="or";
        formulae_to_expr_list(claim, expr.operands());
       }
     }
    else
     {
      expr.id="=>";
      
      if(premise.size()==1)
        expr.operands().push_back(premise.front());
      else
       {
        expr.operands().push_back((exprt &)nil_rep);
        expr.operands()[0].id="and";
        expr.operands()[0].type().id="bool";
        formulae_to_expr_list(premise, expr.operands()[0].operands());
       }

      if(claim.size()==0)
       {
        exprt false_expr;
        expr.make_false();
        expr.operands().push_back(false_expr);
       }
      else if(claim.size()==1)
        expr.operands().push_back(claim.front());
      else
       {
        expr.operands().push_back((exprt &)nil_rep);
        expr.operands()[1].id="or";
        expr.operands()[1].type().id="bool";
        formulae_to_expr_list(claim, expr.operands()[1].operands());
       }
     }
   }
 }

/*******************************************************************\

Function: formula_to_sequent_expr

  Inputs:

 Outputs:

 Purpose: convert formula to sequent expression

\*******************************************************************/

void formula_to_sequent_expr(const formulat &formula, exprt &expr)
 {
  exprt formula_expr;

  formula_expr.operands().push_back(formula);

  if(formula.changed)
    formula_expr.set("#changed", 1);

  if(!formula.labels.empty())
   {
    exprt labels_expr;

    for(std::set<std::string>::const_iterator it=formula.labels.begin();
        it!=formula.labels.end();
        it++)
      labels_expr.set(*it, "");
   }

  expr.move_to_operands(formula_expr);
 }

/*******************************************************************\

Function: formula_from_expr

  Inputs:

 Outputs:

 Purpose: convert expression to sequent

\*******************************************************************/

void formula_from_expr(const exprt &expr, formulaet &formulae)
 {
  if(expr.operands().size()!=1) return;

  formulae.push_back(expr.operands()[0]);
  formulae.back().changed=expr.get_bool("#changed");

  const irept::named_subt &labels=expr.find("labels").get_named_sub();

  forall_named_irep(it, labels)
    formulae.back().labels.insert(it->first);
 }

/*******************************************************************\

Function: sequentt::from_expr

  Inputs:

 Outputs:

 Purpose: convert expression to sequent

\*******************************************************************/

void sequentt::from_expr(const exprt &expr)
 {
  clear();

  const exprt::operandst &operands=expr.operands();

  if(expr.id=="sequent" && operands.size()==2)
   {
    forall_operands(it, operands[0])
      formula_from_expr(*it, premise);

    forall_operands(it, operands[1])
      formula_from_expr(*it, claim);

    comment=expr.get("#comment");
    mode=expr.get("#mode");
    location=expr.find("#location");

    get_symbols(expr.find("symbols"));
   }
  else
   {
    if(expr.id=="=>" && operands.size()==2)
     {
      if(operands[0].id=="and" && operands[0].type().id=="bool")
        expr_list_to_formulae(operands[0].operands(), premise);
      else
        add_premise(operands[0]);

      if(operands[1].id=="or" && operands[1].type().id=="bool")
        expr_list_to_formulae(operands[1].operands(), claim);
      else
        add_claim(operands[1]);
     }
    else
      add_claim(expr);
   }
 }

/*******************************************************************\

Function: sequentt::is_true

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool sequentt::is_true() const
 {
  forall_formulae(it, premise)
    if(it->is_false()) return TRUE;

  forall_formulae(it, claim)
    if(it->is_true()) return TRUE;

  forall_formulae(it, claim)
    forall_formulae(it2, premise)
      if(*it==*it2) return TRUE;

  return FALSE;
 }

/*******************************************************************\

Function: sequentt::make_true

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::make_true()
 {
  clear();

  exprt true_expr;
  true_expr.make_true();
  add_claim(true_expr);
  claim.back().changed=TRUE;
 }

/*******************************************************************\

Function: sequentt::clear

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::clear()
 {
  claim.clear();
  premise.clear();
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/


/*******************************************************************\

Function: sequent::make_false

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::make_false()
 {
  clear();
 }

/*******************************************************************\

Function: sequentt::match_fnum

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool formulat::match_fnum(const fnumt &pattern, int fnum) const
 {
  if(pattern=="*") return TRUE;

  if(pattern=="-" && fnum<0) return TRUE;

  if(pattern=="+" && fnum>0) return TRUE;

  if(pattern==i2string(fnum)) return TRUE;

  if(labels.find(pattern)!=labels.end())
    return TRUE;

  return FALSE;
 }

/*******************************************************************\

Function: sequentt::match_fnum

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool formulat::match_fnum(const fnumst &fnums, int fnum) const
 {
  for(fnumst::const_iterator it=fnums.begin();
      it!=fnums.end();
      it++)
    if(match_fnum(*it, fnum)) return TRUE;

  return FALSE;
 }

/*******************************************************************\

Function: sequentt::match_fnum

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::match_fnum(const fnumst &fnums)
 {
  int i;

  i=0;
  Forall_formulae(it, premise)
   {
    it->match=it->match_fnum(fnums, -(i+1));
    i++;
   }

  i=0;
  Forall_formulae(it, claim)
   {
    it->match=it->match_fnum(fnums, i+1);
    i++;
   }
 }

/*******************************************************************\

Function: formulae_to_expr_list

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void formulae_to_expr_list(const formulaet &formulae,
                           std::vector<exprt> &expr)
 {
  forall_formulae(it, formulae)
    expr.push_back(*it);
 }

/*******************************************************************\

Function: expr_list_to_formulae

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void expr_list_to_formulae(const std::vector<exprt> &expr,
                           formulaet &formulae)
 {
  forall_expr(it, expr)
    formulae.push_back(*it);
 }

/*******************************************************************\

Function: sequentt::set_changed

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::set_changed()
 {
  Forall_formulae(it, premise) it->changed=TRUE;
  Forall_formulae(it, claim) it->changed=TRUE;
 }

/*******************************************************************\

Function: sequentt::set_match

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::set_match()
 {
  Forall_formulae(it, premise) it->match=TRUE;
  Forall_formulae(it, claim) it->match=TRUE;
 }

/*******************************************************************\

Function: sequentt::reset_match

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::reset_match()
 {
  Forall_formulae(it, premise) it->match=FALSE;
  Forall_formulae(it, claim) it->match=FALSE;
 }

/*******************************************************************\

Function: sequentt::reset_changed

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::reset_changed()
 {
  Forall_formulae(it, premise) it->changed=FALSE;
  Forall_formulae(it, claim) it->changed=FALSE;
 }

/*******************************************************************\

Function: sequentt::get_symbols

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::get_symbols(const irept &irep)
 {
  forall_named_irep(it, irep.get_named_sub())
   {
    symbolt symbol;

    symbol.name=it->first;
    symbol.type=((exprt &)(it->second)).type();

    symbols.insert(std::pair<std::string, symbolt>(symbol.name, symbol));
   }
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void sequentt::swap(sequentt &sequent)
 {
  sequent.premise.swap(premise);
  sequent.claim.swap(claim);
  sequent.mode.swap(mode);
  sequent.comment.swap(comment);
  sequent.location.swap(location);
  sequent.symbols.swap(symbols);
 }
