/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "replace_symbol.h"
#include "trfalse.h"

/*******************************************************************\

Function: replace_symbolt::replace

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool replace_symbolt::replace(exprt &dest)
 {
  if(dest.id=="symbol")
   {
    expr_mapt::const_iterator it=
      expr_map.find(dest.get("identifier"));

    if(it!=expr_map.end())
     {
      dest=it->second;
      return FALSE;
     }
   }

  bool result=TRUE;

  Forall_operands(it, dest)
    result=replace(*it) && result;

  result=replace(dest.type()) && result;

  return result;
 }

/*******************************************************************\

Function: replace_symbolt::replace

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool replace_symbolt::replace(typet &dest)
 {
  if(dest.id=="symbol")
   {
    type_mapt::const_iterator it=
      type_map.find(dest.get("identifier"));

    if(it!=type_map.end())
     {
      dest=it->second;
      return FALSE;
     }
   }
  else if(dest.id=="mapping")
   {
    bool result=TRUE;
    result=replace((typet &)dest.find("domain")) && result;
    result=replace((typet &)dest.find("range")) && result;
    return result;
   }
  else if(dest.id=="tuple")
   {
    irept::subt &components=dest.add("components").get_sub();

    bool result=TRUE;

    Forall_irep(it, components)
     {
      result=replace((typet &)*it) && result;
     }

    return result;
   }
  else
   {
    typet &subtype=(typet &)dest.find("subtype");
    if(!subtype.is_nil())
      return replace(subtype);
   }

  return TRUE;
 }
