/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include <algorithm>

#include "i2string.h"
#include "context.h"
#include "rename.h"

using namespace std;

/*******************************************************************\

Function: get_max

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

unsigned get_max(const string &prefix, const symbolst &symbols)
 {
  unsigned max_nr=0;

  forall_symbols(it, symbols)
    if(strncmp(it->first.c_str(), prefix.c_str(), prefix.size())==0)
      max_nr=
        std::max(unsigned(atoi(it->first.c_str()+prefix.size())),
                 max_nr);

  return max_nr;
 }

/*******************************************************************\

Function: get_new_name

  Inputs: symbol to be renamed, sequent,
          context

 Outputs: new symbol

 Purpose: automated variable renaming

\*******************************************************************/

const symbolt get_new_name(const symbolt &symbol,
                           const contextt &context,
                           const sequentt &sequent)
 {
  std::string new_name;

  get_new_name(symbol.name, new_name, context, sequent);
  
  symbolt new_symbol(symbol);
  new_symbol.name=new_name;

  return new_symbol;
 }

/*******************************************************************\

Function: get_new_name

  Inputs: symbol to be renamed, sequent,
          context

 Outputs: new symbol

 Purpose: automated variable renaming

\*******************************************************************/

void get_new_name(const std::string &old_name,
                  std::string &new_name,
                  const contextt &context,
                  const sequentt &sequent)
 {
  if(context.symbols.find(old_name)==context.symbols.end() &&
     sequent.symbols.find(new_name)==sequent.symbols.end())
   {
    new_name=old_name;
    return;
   }

  string prefix=old_name+"_";

  unsigned suffix_nr=std::max(get_max(prefix, context.symbols),
                              get_max(prefix, sequent.symbols))+1;

  new_name=prefix+i2string(suffix_nr);
 }

/*******************************************************************\

Function: get_new_name

  Inputs: symbol to be renamed, context

 Outputs: new symbol

 Purpose: automated variable renaming

\*******************************************************************/

const symbolt get_new_name(const symbolt &symbol,
                           const contextt &context)
 {
  if(context.symbols.find(symbol.name)==context.symbols.end())
    return symbol;

  string prefix=symbol.name+"_";

  unsigned suffix_nr=get_max(prefix, context.symbols)+1;

  symbolt new_symbol(symbol);
  new_symbol.name=prefix+i2string(suffix_nr);

  return new_symbol;
 }

/*******************************************************************\

Function: rename

  Inputs: expression, old name, new name

 Outputs: modifies the expression
          returns false iff something was renamed

 Purpose: automated variable renaming

\*******************************************************************/

bool rename(exprt &expr, const string &old_name,
            const string &new_name)
 {
  bool result=TRUE;

  if(expr.id=="symbol")
   {
    if(expr.get("identifier")==old_name)
     {
      expr.set("identifier", new_name);
      result=FALSE;
     }
   }
  else
   {
    if(expr.id=="address_of")
     {
      // TODO
     }
    else
      Forall_operands(it, expr)
        if(!rename(*it, old_name, new_name))
          result=FALSE;
   }

  return result;
 }
