#ifndef CPROVER_PARSER_H
#define CPROVER_PARSER_H

#include <iostream>
#include <string>
#include <vector>

#include "expr.h"

class parsert
 {
 public:
  std::ostream *err;
  std::istream *in;
  std::string filename;
  
  unsigned line_no;
  
  std::vector<exprt> stack;
  
  virtual void clear()
   {
    line_no=0;
   }
  
  parsert() { }
  
  virtual ~parsert() { }
 };
 
exprt &_newstack(parsert &parser, unsigned &x);

#define newstack(x) _newstack(PARSER, (x))

#define stack(x) (PARSER.stack[x])

#define YY_INPUT(buf,result,max_size) \
    do { \
        for(result=0; result<max_size;) \
         { \
          char ch; \
          if(!PARSER.in->read(&ch, 1)) \
           { \
            if(result==0) result=YY_NULL; \
            break; \
           } \
          \
          if(ch!='\r') \
           { \
            buf[result++]=ch; \
            if(ch=='\n') { PARSER.line_no++; break; } \
           } \
         } \
    } while(0)

#endif
