/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include <iostream>
#include <sysexits.h>

#include "cmdline.h"
#include "parseoptions.h"

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

parseoptions_baset::parseoptions_baset()
 {
  optstring="?hb:(help)";
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

parseoptions_baset::parseoptions_baset(const char *_optstring)
 {
  optstring="?hb:";
  optstring+=_optstring;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void parseoptions_baset::help()
 {
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void parseoptions_baset::usage_error()
 {
  std::cerr << "Usage error!\n\n";
  help();
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

int parseoptions_baset::parseoptions(int argc, char **argv)
 {
  if(cmdline.parse(argc, argv, optstring.c_str()))
   {
    usage_error();
    return EX_USAGE;
   }

  if(cmdline.isset('?') || cmdline.isset('h') || cmdline.isset("help"))
   {
    help();
    return EX_OK;
   }

  return doit();
 }
