/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_NAMESPACE_H
#define CPROVER_NAMESPACE_H

#include "sequent.h"
#include "context.h"

// second: true <=> not found

struct namespacet
 {
  bool lookup(const std::string &name, const symbolt *&symbol) const;
  bool follow_symbol(irept &irep) const;
  bool follow_macros(exprt &expr) const;
  
  namespacet(const contextt &_context)
   { context=&_context; sequent=NULL; }
   
  namespacet(const contextt &_context, const sequentt &_sequent)
   { context=&_context; sequent=&_sequent; }
  
  namespacet(const contextt *_context, const sequentt *_sequent)
   { context=_context; sequent=_sequent; }
  
 protected:
  const contextt *context;
  const sequentt *sequent;
 };

#endif
