/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "trfalse.h"
#include "namespace.h"

/*******************************************************************\

Function: namespacet::lookup

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool namespacet::lookup(const std::string &name,
                        const symbolt *&symbol) const  
 {
  symbolst::const_iterator it;

  if(context!=NULL)
   {
    it=context->symbols.find(name);

    if(it!=context->symbols.end())
     {
      symbol=&(it->second);
      return FALSE;
     }
   }

  if(sequent!=NULL)
   {
    it=sequent->symbols.find(name);

    if(it!=sequent->symbols.end())
     {
      symbol=&(it->second);
      return FALSE;
     }
   }

  return TRUE;
 }

/*******************************************************************\

Function: namespacet::follow_symbol

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool namespacet::follow_symbol(irept &irep) const
 {
  const symbolt *symbol;

  while(irep.id=="symbol")
   {
    const std::string &identifier=irep.get("identifier");

    if(lookup(identifier, symbol)) return TRUE;

    if(symbol->is_type)
     {
      if(!symbol->type.is_nil()) irep=symbol->type;
     }
    else
     {
      if(!symbol->value.is_nil()) irep=symbol->value;
     }
   }

  return FALSE;
 }

/*******************************************************************\

Function: namespacet::follow_macros

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool namespacet::follow_macros(exprt &expr) const
 {
  if(expr.id=="symbol")
   {
    const symbolt *symbol;

    const std::string &identifier=expr.get("identifier");

    if(lookup(identifier, symbol)) return TRUE;

    if(symbol->is_macro && !symbol->value.is_nil())
     {
      expr=symbol->value;
      follow_macros(expr);
     }

    return FALSE;
   }

  bool result=TRUE;

  Forall_operands(it, expr)
    if(!follow_macros(*it))
      result=FALSE;

  return result;
 }
