/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include <strstream>
#include <ctype.h>

#include "mp_arith.h"

/*******************************************************************\

Function: >>

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

mp_integer operator>>(const mp_integer &a, unsigned int b)
 {
  mp_integer result=a;

  for(unsigned i=0; i<b; i++)
    result/=2;

  return result;
 }

/*******************************************************************\

Function: <<

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

mp_integer operator<<(const mp_integer &a, unsigned int b)
 {
  mp_integer result=a;

  for(unsigned i=0; i<b; i++)
    result*=2;

  return result;
 }

/*******************************************************************\

Function: <<

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

std::ostream& operator<<(std::ostream& out, const mp_integer &n)
 {
  out << integer2string(n);
  return out;
 }

/*******************************************************************\

Function: string2integer

  Inputs: string of '0'-'9', most significant digit first

 Outputs: mp_integer

 Purpose:

\*******************************************************************/

const mp_integer string2integer(const std::string &n)
 {
  for(unsigned i=0; i<n.size(); i++)
    if(!(isdigit(n[i]) || (n[i]=='-' && i==0)))
      return 0;

  return mp_integer(n.c_str());
 }

/*******************************************************************\

Function: integer2binary

  Inputs:

 Outputs: string of '0'/'1', most significant bit first

 Purpose:

\*******************************************************************/

const std::string integer2binary(const mp_integer &n, unsigned width)
 {
  mp_integer a(n);

  if(width==0) return "";

  bool neg=a.is_negative();

  if(neg)
   {
    a.negate();
    a=a-1;
   }

  unsigned len = a.digits(2) + 2;
  char *buffer=(char *)malloc(len);
  char *s = a.as_string(buffer, len, 2);

  std::string result(s);

  free(buffer);

  if(result.size()<width)
   {
    std::string fill;
    fill.resize(width-result.size(), '0');
    result=fill+result;
   }
  else if(result.size()>width)
    result=result.substr(result.size()-width, width);

  if(neg)
    for(unsigned i=0; i<result.size(); i++)
      result[i]=(result[i]=='0')?'1':'0';

  return result;
 }

/*******************************************************************\

Function: integer2string

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

const std::string integer2string(const mp_integer &n)
 {
  unsigned len = n.digits(10) + 2;
  char *buffer=(char *)malloc(len);
  char *s = n.as_string(buffer, len, 10);

  std::string result(s);

  free(buffer);

  return result;
 }

/*******************************************************************\

Function: binary2integer

  Inputs: string of '0'/'1', most significant bit first

 Outputs: mp_integer

 Purpose: convert binary string representation to mp_integer

\*******************************************************************/

const mp_integer binary2integer(const std::string &n, bool is_signed)
 {
  if(n.size()==0) return 0;

  mp_integer result=0;
  mp_integer mask=1;
  mask=mask << (n.size()-1);

  for(unsigned i=0; i<n.size(); i++)
   {
    if(n[i]=='0')
     {
     }
    else if(n[i]=='1')
     {
      if(is_signed && i==0)
        result=-mask;
      else
        result=result+mask;
     }
    else
      return 0;

    mask=mask>>1;
   }

  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

unsigned long integer2long(const mp_integer &n)
 {
  return n.to_ulong();
 }
