/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_MESSAGE_H

#define CPROVER_MESSAGE_H

#include <string>

class message_handlert
 {
 public:
  virtual void print(const std::string &message) = 0;
 };
 
class messaget
 {
 public:
  virtual void print(const std::string &message)
   { print(1, message); }
    
  virtual void print(unsigned level, const std::string &message);
  
  virtual void set_message_handler(message_handlert *_message_handler);
  virtual void set_verbosity(unsigned _verbosity)
   { verbosity=_verbosity; }
  
  messaget()
   {
    message_handler=(message_handlert *)NULL;
    verbosity=10;
   }
   
  virtual ~messaget() {  }
  
  // Levels:
  //
  //  0 none
  //  1 only errors
  //  2 + warnings
  //  4 + results
  //  6 + phase information
  //  8 + statistical information
  //  9 + progress information
  // 10 + debug info

 protected:
  unsigned verbosity;
  message_handlert *message_handler;
 };

#endif
