/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "replace_expr.h"
#include "map_util.h"

/*******************************************************************\

Function: mapping_to_lambda

  Inputs:

 Outputs:

 Purpose: converts a mapping type to an incomplete lambda
          expression

\*******************************************************************/

void mapping_to_lambda(const typet &type, exprt &expr)
 {
  if(type.id!="mapping")
    throw "expected mapping type";

  const typet &domain=(typet &)type.find("domain");
  const typet &range =(typet &)type.find("range");

  expr.clear();
  expr.type()=type;
  expr.id="lambda";
  expr.operands().resize(2);
  expr.operands()[1].type()=range;

  exprt &op=expr.operands()[0];
  op.type()=domain;

  if(domain.id=="tuple")
   {
    op.id="tuple";

    const irept &components=domain.find("components");

    op.operands().resize(components.get_sub().size());

    for(unsigned i=0; i<op.operands().size(); i++)
     {
      op.operands()[i].id="quant_symbol";
      op.operands()[i].type()=(typet &)components.get_sub()[i];
     }
   }
  else
    op.id="quant_symbol";
 }

/*******************************************************************\

Function: tuple_component

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void tuple_component(const exprt &src, unsigned nr, exprt &dest)
 {
  dest.clear();

  if(src.id=="tuple")
   {
    if(nr>=src.operands().size())
      throw "tuple has not enough components";

    dest=src.operands()[nr];
   }
  else
   {
    dest.id="member";
    dest.set("component", nr);
    dest.copy_to_operands(src);
   }
 }

/*******************************************************************\

Function: expand_map

  Inputs:

 Outputs:

 Purpose: expands a map operator

\*******************************************************************/

void expand_map(exprt &expr)
 {
  // sanity checks

  if(expr.id!="map")
    throw "expected mapping";

  if(expr.operands().size()!=2)
    throw "mapping takes two operands";

  exprt &lambda=expr.operands()[0];

  if(lambda.id!="lambda")
    throw "expected lambda expression as first operand";

  if(lambda.operands().size()!=2)
    throw "lambda takes two operands";

  // build replace_map

  replace_mapt replace_map;

  if(lambda.operands()[0].id=="tuple")
   {
    unsigned nr=0;

    forall_operands(it, lambda.operands()[0])
     {
      exprt tmp;
      tuple_component(expr.operands()[1], nr, tmp);
      replace_map.insert(pair<exprt, exprt>(*it, tmp));
      nr++;
     }
   }
  else
    replace_map.insert
      (pair<exprt, exprt>(lambda.operands()[0], expr.operands()[1]));

  // build new expression

  exprt new_expr;
  new_expr.swap(lambda.operands()[1]);
  replace_expr(replace_map, new_expr);
  expr.swap(new_expr);
 }
