/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "location.h"

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

const irept &find_location(const exprt &expr)
 {
  const irept &location=expr.find("#location");

  if(!location.is_nil()) return location;

  forall_operands(it, expr)
   {
    const irept &location=find_location(*it);
    if(!location.is_nil()) return location;
   }

  return nil_rep;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

std::string location_string(const irept &location)
 {
  std::string dest;

  const std::string file=location.get("file");
  const std::string line=location.get("line");
  const std::string function=location.get("function");

  if(file!="") { if(dest!="") dest+=" "; dest+="file "+file; }
  if(line!="") { if(dest!="") dest+=" "; dest+="line "+line; }
  if(function!="") { if(dest!="") dest+=" "; dest+="function "+function; }

  return dest;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void location(std::ostream &out, const irept &irep)
 {
  const irept &location=irep.find("#location");

  if(location.is_nil()) return;

  out << location_string(location) << std::endl;
 }

