/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_LANGUAGE_FILE_H
#define CPROVER_LANGUAGE_FILE_H

#include <iostream>
#include <set>

#include "context.h"

class language_filet
 {
 public:
  std::set<std::string> modules;
  class languaget *language;
  bool type_checked, in_progress;
  std::string filename;
  
  void get_modules();
  
  language_filet() { language=NULL; type_checked=in_progress=FALSE; }
  ~language_filet();
 };
 
class language_filest
 {
 public:
  typedef std::map<std::string, language_filet> filemapt;
  filemapt filemap;

  typedef std::map<std::string, std::string> modulemapt;
  modulemapt modulemap;

  bool parse(std::string &error);
  bool parse(ostream &err);
  bool typecheck(contextt &context, std::string &error);
  bool typecheck(contextt &context, ostream &err);
  
  bool typecheck_file(contextt &context,
                      language_filet &file,
                      std::ostream &err);

 protected:                      
  bool typecheck_module(contextt &context,
                        const std::string &module,
                        std::ostream &err,
                        const std::string &current_file);
 };
 
#endif
