/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include <fstream>

#include "language.h"
#include "language_file.h"
#include "strstream2string.h"

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

language_filet::~language_filet()
 {
  if(language!=NULL) delete language;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void language_filet::get_modules()
 {
  language->modules_provided(modules);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool language_filest::parse(std::string &error)
 {
  std::ostrstream err;
  bool result=parse(err);
  strstream2string(err, error);
  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool language_filest::parse(std::ostream &err)
 {
  for(filemapt::iterator it=filemap.begin();
      it!=filemap.end(); it++)
   {
    // open file

    std::ifstream infile(it->first.c_str());

    if(!infile)
     {
      err << "Failed to open " << it->first << std::endl;
      return TRUE;
     }

    // parse it

    languaget &language=*(it->second.language);

    if(language.parse(infile, it->first, err))
     {
      err << "Parsing of " << it->first << " failed" << std::endl;
      return TRUE;
     }

    // what is provided?

    it->second.get_modules();
   }

  return FALSE;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool language_filest::typecheck(contextt &context, std::string &error)
 {
  std::ostrstream err;
  bool result=typecheck(context, err);
  strstream2string(err, error);
  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool language_filest::typecheck(contextt &context, std::ostream &err)
 {
  // build module map

  for(filemapt::iterator fm_it=filemap.begin();
      fm_it!=filemap.end(); fm_it++)
   {
    std::set<std::string> &modules=fm_it->second.modules;

    for(std::set<std::string>::const_iterator mo_it=modules.begin();
        mo_it!=modules.end(); mo_it++)
      modulemap.insert(pair<std::string, std::string>(*mo_it, fm_it->first));
   }

  // typecheck files

  for(filemapt::iterator it=filemap.begin();
      it!=filemap.end(); it++)
   {
    if(typecheck_file(context, it->second, err))
      return TRUE;
   }

  return FALSE;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool language_filest::typecheck_file(contextt &context,
                                     language_filet &file,
                                     std::ostream &err)
 {
  // already typechecked?

  if(file.type_checked)
    return FALSE;

  // already in progress?

  if(file.in_progress)
   {
    err << "circular dependancy in " << file.filename << std::endl;
    return TRUE;
   }

  file.in_progress=TRUE;

  // first get dependancies of current file

  std::set<std::string> dependancy_set;

  file.language->dependancies(dependancy_set);

  for(std::set<std::string>::const_iterator it=
      dependancy_set.begin();
      it!=dependancy_set.end();
      it++)
   {
    if(typecheck_module(context, *it, err,
                        file.filename))
      return TRUE;
   }

  // type check it

  if(file.language->typecheck(context, err))
    return TRUE;

  file.type_checked=TRUE;
  file.in_progress=FALSE;

  return FALSE;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool language_filest::typecheck_module(contextt &context,
                                       const std::string &module,
                                       std::ostream &err,
                                       const std::string &current_file)
 {
  // check module map

  modulemapt::const_iterator it=modulemap.find(module);

  if(it==modulemap.end())
   {
    err << "found no file that provides module " << module << std::endl;
    return TRUE;
   }

  filemapt::iterator it2=filemap.find(it->second);

  if(it2==filemap.end())
   {
    err << "file " << it->second << " not found in filemap" << std::endl;
    return TRUE;
   }

  if(current_file!=it2->second.filename)
    if(typecheck_file(context, it2->second, err))
      return TRUE;

  return FALSE;
 }

