/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_LANGUAGE_H
#define CPROVER_LANGUAGE_H

#include <iostream>
#include <set>

#include "context.h"
#include "sequent.h"
#include "cmdline.h"

class languaget
 {
 public:
  // parse file
 
  virtual bool parse(std::istream &instream,
                     const std::string &path,
                     std::ostream &err)=0;

  virtual bool parse(std::istream &instream,
                     const std::string &path,
                     std::string &error);
  
  // add external dependancies of currently parsed file to set
  
  virtual void dependancies(std::set<std::string> &modules)
   { }

  // add modules provided by currently parsed file to set

  virtual void modules_provided(std::set<std::string> &modules)
   { }

  // type check currently parsed file

  virtual bool typecheck(contextt &context, std::string &error);
  virtual bool typecheck(contextt &context, std::ostream &err)=0;
  
  // add initialization code

  virtual void initialize_variables(const contextt &context,
                                    const symbolt &symbol,
                                    sequentt &sequent) { }

  // show parse tree / type checked file

  virtual void show_parse()=0;
             
  virtual void stdio_parse();   // from stdin to stdout
  virtual void stdio_convert(); // from stdin to stdout
  virtual void cmdline_parse(cmdlinet &cmdline);   // from cmdline to stdout
  virtual void cmdline_convert(cmdlinet &cmdline); // from cmdline to stdout
  
  // conversion of expressions
  
  virtual bool from_expr(const exprt &expr, std::string &code,
                         const contextt &context,
                         const sequentt &sequent)=0;
                         
  virtual bool to_expr(const std::string &code, exprt &expr,
                       std::string &error,
                       const contextt &context,
                       const sequentt &sequent);
  
  virtual bool to_expr(const std::string &code, exprt &expr,
                       std::ostream &error,
                       const contextt &context,
                       const sequentt &sequent)=0;
                       
  virtual languaget *new_language()=0;
  
  // constructor / destructor
  
  languaget() { }
  virtual ~languaget() { }
 };
#endif
