/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "language.h"
#include "strstream2string.h"

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool languaget::parse(std::istream &instream,
                      const std::string &path,
                      std::string &error)
 {
  std::ostrstream err;
  bool result=parse(instream, path, err);
  strstream2string(err, error);
  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool languaget::typecheck(contextt &context, std::string &error)
 {
  std::ostrstream err;
  bool result=typecheck(context, err);
  strstream2string(err, error);
  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool languaget::to_expr(const std::string &code,
                        exprt &expr,
                        std::string &error,
                        const contextt &context,
                        const sequentt &sequent)
 {
  std::ostrstream err;
  bool result=to_expr(code, expr, err, context, sequent);
  strstream2string(err, error);
  return result;
 }

/*******************************************************************\

Function: languaget::stdio_parse

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/
             
void languaget::stdio_parse()
 {
  std::string error;

  if(parse(cin, "", error))
    std::cout << "PARSE ERROR" << std::endl;

  if(error!="")
    std::cout << error << std::endl;

  show_parse();
 }

/*******************************************************************\

Function: languaget::stdio_convert

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void languaget::stdio_convert()
 {
  std::string error;
  contextt context;

  std::cout << "Parsing" << std::endl;

  if(parse(cin, "", error))
    std::cout << "PARSE ERROR" << std::endl;
  else
   {
    // show warnings
    if(error!="")
     {
      std::cout << error << std::endl;
      error="";
     }

    std::cout << "Type checking" << std::endl;

    if(typecheck(context, error))
      std::cout << "CONVERT ERROR" << std::endl;
   }

  if(error!="")
    std::cout << error << std::endl;

  context.show(std::cout);
 }

/*******************************************************************\

Function: languaget::stdio_parse

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/
             
void languaget::cmdline_parse(cmdlinet &cmdline)
 {
  std::string error;

  if(parse(cin, "", error))
    std::cout << "PARSE ERROR" << std::endl;

  if(error!="")
    std::cout << error << std::endl;

  show_parse();
 }

/*******************************************************************\

Function: languaget::stdio_convert

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void languaget::cmdline_convert(cmdlinet &cmdline)
 {
  std::string error;
  contextt context;

  std::cout << "Parsing" << std::endl;

  if(parse(cin, "", error))
    std::cout << "PARSE ERROR" << std::endl;
  else
   {
    // show warnings
    if(error!="")
     {
      std::cout << error << std::endl;
      error="";
     }

    std::cout << "Type checking" << std::endl;

    if(typecheck(context, error))
      std::cout << "CONVERT ERROR" << std::endl;
   }

  if(error!="")
    std::cout << error << std::endl;

  context.show(std::cout);
 }

