/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_IREP_H
#define CPROVER_IREP_H

#include <vector>
#include <map>
#include <string>

typedef std::string irep_string;

#define forall_irep(it, irep) \
  for(irept::subt::const_iterator it=(irep).begin(); \
      it!=(irep).end(); it++)

#define Forall_irep(it, irep) \
  for(irept::subt::iterator it=(irep).begin(); \
      it!=(irep).end(); it++)

#define forall_named_irep(it, irep) \
  for(irept::named_subt::const_iterator it=(irep).begin(); \
      it!=(irep).end(); it++)

#define Forall_named_irep(it, irep) \
  for(irept::named_subt::iterator it=(irep).begin(); \
      it!=(irep).end(); it++)

class irept
 {
 public:
  typedef std::vector<irept> subt;
  typedef std::map<irep_string, irept> named_subt;

  virtual ~irept() { }
  irep_string id;

  virtual bool is_nil() const { return id=="nil"; }
  irept() { }
  irept(const irep_string &_id):id(_id) { }
  
  irept &find(const irep_string &name);
  const irept &find(const irep_string &name) const;
  irept &add(const irep_string &name);

  const irep_string &get(const irep_string &name) const;
  bool get_bool(const irep_string &name) const;

  void set(const irep_string &name, const irep_string &value)
   { add(name).id=value; }
  
  void set(const irep_string &name, const long value);
  void set(const irep_string &name, const irept &irep);
  void remove(const irep_string &name);
  void move_to_sub(irept &irep);
  void move_to_named_sub(const irep_string &name, irept &irep);
  
  friend bool operator==(const irept &i1, const irept &i2);
   
  friend bool operator!=(const irept &i1, const irept &i2)
   { return !(i1==i2); }

  friend std::ostream& operator<< (std::ostream& out, const irept &irep);
  
  irep_string to_string() const;
  
  void swap(irept &irep);

  friend bool operator<(const irept &i1, const irept &i2);
  friend bool ordering(const irept &i1, const irept &i2);
  
  void clear() { id=""; sub.clear(); named_sub.clear(); comments.clear(); }
  void make_nil() { clear(); id="nil"; }
  
  subt &get_sub() { return sub; }
  const subt &get_sub() const { return sub; }
  named_subt &get_named_sub() { return named_sub; }
  const named_subt &get_named_sub() const { return named_sub; }
  named_subt &get_comments() { return comments; }
  const named_subt &get_comments() const { return comments; }
  
  size_t hash() const;
  
  std::string pretty(unsigned indent=0) const;
  
 protected:
  bool is_comment(const irep_string &name) const
   { return name!="" && name[0]=='#'; }

  named_subt named_sub;
  named_subt comments;
  subt sub;  
 };

extern const irept nil_rep;

size_t hash_irep_string(const irep_string &s);

struct irep_string_hash
 {
  size_t operator()(const irep_string &s) const { return hash_irep_string(s); }
 };

struct irep_hash
 {
  size_t operator()(const irept &irep) const { return irep.hash(); }
 };

#endif
