/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include <strstream>

#include "i2string.h"
#include "strstream2string.h"

/*******************************************************************\

Function: i2string

  Inputs: signed integer

 Outputs: string class

 Purpose: convert signed integer to string class

\*******************************************************************/

std::string i2string(int i)
 {
  std::ostrstream strInt;

  strInt << i;
  std::string str;
  strstream2string(strInt, str);

  return str; 
 }

/*******************************************************************\

Function: i2string

  Inputs: unsigned integer

 Outputs: string class

 Purpose: convert unsigned integer to string class

\*******************************************************************/

std::string i2string(unsigned i)
 {
  std::ostrstream strInt;

  strInt << i;
  std::string str;
  strstream2string(strInt, str);

  return str; 
 }

