/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_H_SEQUENT_H

#define CPROVER_H_SEQUENT_H

//
// a Gentzen-Hoare sequent
//

#include "sequent.h"

class h_sequentt:public sequentt
 {
 public:
  exprt code;
  
  h_sequentt() { code.make_nil(); }
  h_sequentt(const sequentt &_sequent, const exprt &_code):
    sequentt(_sequent), code(_code) { }
  
  virtual void from_expr(const exprt &expr);
  virtual void to_expr(exprt &expr, bool full) const;
  virtual bool is_true() const;
  virtual void swap(h_sequentt &h_sequent);
  virtual void clear();
 };
 
void make_Hoare_sequent(const exprt &code, h_sequentt &h_sequent);

#endif
