/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "h_sequent.h"
#include "trfalse.h"

/*******************************************************************\

Function: h_sequentt::from_expr

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void h_sequentt::from_expr(const exprt &expr)
 {
  const exprt::operandst &operands=expr.operands();

  if(expr.id=="Hoare" && operands.size()==2)
   {
    clear();

    forall_operands(it, operands[0])
      formula_from_expr(*it, premise);

    forall_operands(it, operands[1])
      formula_from_expr(*it, claim);

    code=(exprt &)expr.find("code");
    comment=expr.get("#comment");
    mode=expr.get("#mode");
    location=expr.find("#location");

    get_symbols(expr.find("symbols"));
   }
  else
   {
    code.make_nil();
    sequentt::from_expr(expr);
   }
 }

/*******************************************************************\

Function: h_sequentt::to_expr

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void h_sequentt::to_expr(exprt &expr, bool full) const
 {
  sequentt::to_expr(expr, full);

  if(!code.is_nil())
   {
    expr.id="Hoare";
    expr.set("code", code);
   }
 }

/*******************************************************************\

Function: h_sequentt::is_true

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool h_sequentt::is_true() const
 {
  if(code.is_nil()) return sequentt::is_true();

  forall_formulae(it, premise)
    if(it->is_false()) return TRUE;

  return FALSE;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void make_Hoare_sequent(const exprt &code, h_sequentt &h_sequent)
 {
  h_sequent.code=code;

  exprt true_expr;
  true_expr.make_true();
  h_sequent.claim.push_back(true_expr);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void h_sequentt::swap(h_sequentt &h_sequent)
 {
  sequentt::swap(h_sequent);
  code.swap(h_sequent.code);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void h_sequentt::clear()
 {
  sequentt::clear();
  code.make_nil();
 }
