/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "expr_util.h"
#include "trfalse.h"

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_true()
 {
  exprt result;
  result.make_true();
  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_false()
 {
  exprt result;
  result.make_false();
  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_zero(const typet &type)
 {
  exprt result;
  result.type()=type;
  result.make_zero();
  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_not(const exprt &op)
 {
  return gen_unary("not", typet("bool"), op);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_unary(const std::string &id, const typet &type, const exprt &op)
 {
  exprt result;
  result.id=id;
  result.type()=type;
  result.copy_to_operands(op);
  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_binary(const std::string &id, const typet &type, const exprt &op1, const exprt &op2)
 {
  exprt result;
  result.id=id;
  result.type()=type;
  result.copy_to_operands(op1);
  result.copy_to_operands(op2);
  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_and(const exprt &op1, const exprt &op2)
 {
  return gen_binary("and", typet("bool"), op1, op2);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_or(const exprt &op1, const exprt &op2)
 {
  return gen_binary("or", typet("bool"), op1, op2);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_implies(const exprt &op1, const exprt &op2)
 {
  return gen_binary("=>", typet("bool"), op1, op2);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

exprt gen_equal(const exprt &op1, const exprt &op2)
 {
  return gen_binary("=", typet("bool"), op1, op2);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void gen_binary(exprt &expr, const std::string &id, bool default_value)
 {
  if(expr.operands().size()==0)
   {
    if(default_value)
      expr.make_true();
    else
      expr.make_false();
   }
  else if(expr.operands().size()==1)
   {
    exprt tmp;
    tmp.swap(expr.operands()[0]);
    expr.swap(tmp);
   }
  else
   {
    expr.id=id;
    expr.type()=typet("bool");
   }
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void gen_and(exprt &expr)
 {
  gen_binary(expr, "and", TRUE);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void gen_or(exprt &expr)
 {
  gen_binary(expr, "or", FALSE);
 }
