/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_EXPR_H
#define CPROVER_EXPR_H

#include <iostream>

#include "type.h"

#define forall_operands(it, expr) \
  if(!(expr).find("operands").is_nil()) \
    for(exprt::operandst::const_iterator it=(expr).operands().begin(); \
        it!=(expr).operands().end(); it++)

#define Forall_operands(it, expr) \
  if(!(expr).find("operands").is_nil()) \
    for(exprt::operandst::iterator it=(expr).operands().begin(); \
        it!=(expr).operands().end(); it++)

#define forall_expr(it, expr) \
  for(std::vector<exprt>::const_iterator it=(expr).begin(); \
      it!=(expr).end(); it++)

#define Forall_expr(it, expr) \
  for(std::vector<exprt>::iterator it=(expr).begin(); \
      it!=(expr).end(); it++)
      
#define forall_expr_list(it, expr) \
  for(expr_listt::const_iterator it=(expr).begin(); \
      it!=(expr).end(); it++)

#define Forall_expr_list(it, expr) \
  for(expr_listt::iterator it=(expr).begin(); \
      it!=(expr).end(); it++)

class exprt:public irept
 {
 public:
  typedef std::vector<exprt> operandst;
 
  typet &type() { return (typet &)add("type"); }
  const typet &type() const { return (typet &)find("type"); }

  operandst &operands()
   { return (std::vector<exprt> &)add("operands").get_sub(); }
  
  const operandst &operands() const
   { return (const std::vector<exprt> &)find("operands").get_sub(); }
   
  void move_to_operands(exprt &expr); // destroys expr
  void copy_to_operands(const exprt &expr); // does not destroy expr

  void make_typecast(const typet &_type);
  void make_not();
  
  void make_true();
  void make_false();
  void make_bool(bool value);
  void make_zero();
  void make_one();
  void negate();
  bool sum(const exprt &expr);
  bool mul(const exprt &expr);
  bool subtract(const exprt &expr);
  
  bool is_constant() const;
  bool is_true() const;
  bool is_false() const;
  bool is_zero() const;
  bool is_one() const;
  bool is_boolean() const;
  
  friend bool operator<(const exprt &X, const exprt &Y);
 };

typedef std::list<exprt> expr_listt;

#endif
