/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_CONTEXT_H
#define CPROVER_CONTEXT_H

#include <iostream>

#include <map>
#include <hash_map.h>

#include "type.h"
#include "symbol.h"

typedef std::hash_map<std::string, symbolt, irep_string_hash> symbolst;
//typedef std::map<std::string, symbolt> symbolst;

#define forall_symbols(it, expr) \
  for(symbolst::const_iterator it=(expr).begin(); \
      it!=(expr).end(); it++)

typedef std::multimap<std::string, std::string> symbol_base_mapt;

#define forall_symbol_base_map(it, expr, base_name) \
  for(symbol_base_mapt::const_iterator it=(expr).lower_bound(base_name), \
                                       it_end=(expr).upper_bound(base_name); \
      it!=it_end; it++)

class contextt
 {
 public:
  symbolst symbols;
  symbol_base_mapt symbol_base_map;
  
  bool add(const symbolt &symbol);
   
  void clear()
   {
    symbols.clear();
    symbol_base_map.clear();
   }
   
  void show(std::ostream &out);
 };

#endif
