/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "context.h"

/*******************************************************************\

Function: contextt::add

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool contextt::add(const symbolt &symbol)
 {
  if(!symbols.insert(std::pair<std::string, symbolt>(symbol.name, symbol)).second)
    return TRUE;
    
  symbol_base_map.insert(std::pair<std::string, std::string>(symbol.base_name, symbol.name));

  return FALSE;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void contextt::show(std::ostream &out)
 {
  out << std::endl << "Symbols:" << std::endl;

  forall_symbols(it, symbols)
   {
    out << "  " << it->second.name << std::endl;
    out << "    type:  " << it->second.type.pretty(4) << std::endl
        << "    value: " << it->second.value.pretty(4) << std::endl;

    out << "  flags:";
    if(it->second.lvalue)        out << " lvalue";
    if(it->second.is_static)     out << " static";
    if(it->second.theorem)       out << " theorem";
    if(it->second.axiom)         out << " axiom";
    if(it->second.is_type)       out << " type";
    if(it->second.is_input)      out << " input";
    if(it->second.is_output)     out << " output";
    if(it->second.is_macro)      out << " macro";
    if(it->second.mode!="")      out << " mode=" << it->second.mode;
    if(it->second.base_name!="") out << " base_name=" << it->second.base_name;
    if(it->second.module!="")    out << " module=" << it->second.module;
    out << std::endl << std::endl;
   }
 }
