#include "cnf_simplify.h"
#include "trfalse.h"

void propagate_not(exprt &expr);

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void cnf_simplify(exprt &expr)
 {
  Forall_operands(it, expr)
    cnf_simplify(*it);

  if(expr.id=="and" || expr.id=="or")
   {
    exprt tmp;

    if(expr.operands().size()==1)
     {
      tmp.swap(expr.operands()[0]);
      expr.swap(tmp);
     }
    else
     {
      Forall_operands(it, expr)
       {
        if(it->id==expr.id)
         {
          Forall_operands(it2, *it)
            tmp.move_to_operands(*it2);
         }
        else
          tmp.move_to_operands(*it);
       }

      expr.operands().swap(tmp.operands());
     }
   }
  else if(expr.id=="not")
   {
    if(expr.operands().size()==1)
     {
      exprt tmp;

      tmp.swap(expr.operands()[0]);
      propagate_not(tmp);
      expr.swap(tmp);
     }
   }
  else if(expr.id=="=>")
   {
    if(expr.operands().size()==2)
     {
      expr.id="or";
      propagate_not(expr.operands()[0]);
     }
   }
 }

/*******************************************************************\

Function: propagate_not

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void propagate_not(exprt &expr)
 {
  if(expr.id=="and" || expr.id=="or")
   {
    if(expr.id=="and")
      expr.id="or";
    else // or
      expr.id="and";

    Forall_operands(it, expr)
      propagate_not(*it);
   }
  else if(expr.id=="not")
   {
    assert(expr.operands().size()==1);
    exprt tmp;
    tmp.swap(expr.operands()[0]);
    expr.swap(tmp);
   }
  else if(expr.id=="=")
    expr.id="notequal";
  else if(expr.id=="notequal")
    expr.id="=";
  else
   {
    exprt tmp;
    expr.swap(tmp);
    expr.id="not";
    expr.type()=tmp.type();
    expr.move_to_operands(tmp);
   }
 }
