/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef DBOX_CMDLINE_H

#define DBOX_CMDLINE_H

#define TRUE 1
#define FALSE 0

#include <vector>
#include <string>

class cmdlinet
 {
 public:
  bool parse(int argc, char **argv, const char *optstring);
  const char *getval(char option);
  const char *getval(const char *option);
  bool isset(char option);
  bool isset(const char *option);

  void clear();
  
  std::vector<std::string> args;
  
  cmdlinet();
  ~cmdlinet();
  
 private:
  struct optiont
   {
    bool isset, hasval, islong;
    char optchar;
    std::string optstring, value;
   };
   
  std::vector<optiont> options;

  int getoptnr(char option);
  int getoptnr(const char *option);
 };

#endif
