/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include <iostream>

#include "cmdline.h"

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

cmdlinet::cmdlinet()
 {
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

cmdlinet::~cmdlinet()
 {
  clear();
 }

void cmdlinet::clear()
 {
  options.clear();
  args.clear();
 }

bool cmdlinet::isset(char option)
 {
  int i;

  i=getoptnr(option);
  if(i<0) return FALSE;
  return options[i].isset;
 }

bool cmdlinet::isset(const char *option)
 {
  int i;

  i=getoptnr(option);
  if(i<0) return FALSE;
  return options[i].isset;
 }

const char *cmdlinet::getval(char option)
 {
  int i;

  i=getoptnr(option);
  if(i<0) return (const char *)NULL;
  return options[i].value.c_str();
 }

const char *cmdlinet::getval(const char *option)
 {
  int i;

  i=getoptnr(option);
  if(i<0) return (const char *)NULL;
  return options[i].value.c_str();
 }

int cmdlinet::getoptnr(char option)
 {
  for(unsigned i=0; i<options.size(); i++)
    if(options[i].optchar==option)
      return i;
  
  return -1;
 }

int cmdlinet::getoptnr(const char *option)
 {
  for(unsigned i=0; i<options.size(); i++)
    if(options[i].optstring==option)
      return i;
  
  return -1;
 }

bool cmdlinet::parse(int argc, char **argv, const char *optstring)
 {
  clear();

  while(optstring[0]!=0)
   {
    optiont option;

    if(optstring[0]==':')
     {
      std::cerr << "cmdlinet::parse: Invalid option string" << std::endl;
      abort();
     }

    if(optstring[0]=='(')
     {
      option.islong=TRUE;
      option.optchar=0;
      option.isset=FALSE;
      option.value="";
      option.optstring="";

      for(optstring++; optstring[0]!=')' && optstring[0]!=0; optstring++)
        option.optstring+=optstring[0];

      if(optstring[0]==')') optstring++;
     }
    else
     {
      option.islong=FALSE;
      option.optchar=optstring[0];
      option.optstring="";
      option.isset=FALSE;
      option.value="";

      optstring++;
     }

    if(optstring[0]==':')
     {
      option.hasval=TRUE;
      optstring++;
     }
    else
      option.hasval=FALSE;

    options.push_back(option);
   }

  for(int i=1; i<argc; i++)
   {
    if(argv[i][0]!='-')
      args.push_back(argv[i]);
    else
     {
      int optnr;

      if(argv[i][1]=='-')
        optnr=getoptnr(argv[i]+2);
      else
        optnr=getoptnr(argv[i][1]);
   
      if(optnr<0) return TRUE;
      options[optnr].isset=TRUE;
      if(options[optnr].hasval)
       {
        if(argv[i][2]==0 || options[optnr].islong)
         {
          i++;
          if(i==argc) return TRUE;
          if(argv[i][0]=='-') return TRUE;
          options[optnr].value=argv[i];
         }
        else
          options[optnr].value=argv[i]+2;
       }
     }
   }

  return FALSE;
 }
