#include "arith_tools.h"
#include "bitvector.h"
#include "trfalse.h"

/*******************************************************************\

Function: to_integer

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool to_integer(const exprt &expr, mp_integer &int_value)
 {
  if(!expr.is_constant()) return TRUE;

  const std::string &value=expr.get("value");
  const std::string &type_id=expr.type().id;

  if(type_id=="integer" || type_id=="natural")
   {
    int_value=string2integer(value);
    return FALSE;
   }
  else if(type_id=="unsignedbv")
   {
    int_value=binary2integer(value, FALSE);
    return FALSE;
   }
  else if(type_id=="signedbv")
   {
    int_value=binary2integer(value, TRUE);
    return FALSE;
   }

  return TRUE;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool from_integer(const mp_integer &int_value, exprt &expr)
 {
  typet type=expr.type();

  expr.clear();
  expr.type()=type;
  expr.id="constant";

  if(type.id=="integer")
   {
    expr.set("value", integer2string(int_value));
    return FALSE;
   }
  else if(type.id=="natural")
   {
    if(int_value<=0) return TRUE;
    expr.set("value", integer2string(int_value));
    return FALSE;
   }
  else if(type.id=="unsignedbv" || type.id=="signedbv")
   {
    expr.set("value", integer2binary(int_value, bv_width(type)));
    return FALSE;
   }

  return TRUE;
 }
