/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "actuals.h"

/*******************************************************************\

Function: get_actual_map

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void get_actual_map(const exprt &expr,
                    replace_symbolt &actual_map)
 {
  forall_operands(it, expr)
   {
    if(it->id!="actual" ||
       it->operands().size()!=1)
      throw "expected actual";

    const exprt &value=it->operands()[0];
    const std::string &identifier=it->get("identifier");

    if(value.id=="type")
      actual_map.type_map.insert(
        pair<std::string, typet>(identifier, value.type()));
    else
      actual_map.expr_map.insert(
        pair<std::string, exprt>(identifier, value));
   }
 }

