#ifndef SMV_PARSER_H
#define SMV_PARSER_H

#include <list.h>
#include <hash_map.h>

#include "parser.h"
#include "expr.h"
#include "trfalse.h"

class smv_parset
 {
 public:

  struct mc_vart
   {
    unsigned size, offset;
    bool declared, used_with_next;
    enum typet { BOOL, ARRAY, RANGE } type;
    
    mc_vart() 
     {
      size=1;
      offset=0;
      declared=FALSE;
      used_with_next=FALSE;
      type=BOOL;
     }
   };
   
  typedef std::hash_map<std::string, mc_vart, irep_string_hash> mc_varst;

  struct modulet
   {
    std::string name;
    expr_listt spec, init, trans, define, invar, fairness;
    mc_varst vars;
   };
   
  typedef std::list<modulet> modulest;
  
  modulest modules;
  
  void swap(smv_parset &smv_parse);
  void clear();
 };

class smv_parsert:public parsert
 {
 public:
  smv_parset parse;  
  smv_parset::modulet *module;
  
  virtual void clear()
   {
    parsert::clear();
    parse.clear();
    module=NULL;
   }
 };

extern smv_parsert smv_parser;

int yysmvparse();

#endif
