/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_SMV_LANGUAGE_H
#define CPROVER_SMV_LANGUAGE_H

#include "language.h"
#include "smv_parser.h"

class smv_languaget:public languaget
 {
 public:
  virtual bool parse(std::istream &instream,
                     const std::string &path,
                     std::ostream &err);

  virtual void dependancies(std::set<std::string> &module_set);
  virtual void modules_provided(std::set<std::string> &module_set);
                 
  virtual bool typecheck(contextt &context, std::ostream &err);
  
  virtual void show_parse();
  
  virtual ~smv_languaget() { }
  
  virtual bool from_expr(const exprt &expr, std::string &code,
                         const contextt &context,
                         const sequentt &sequent);
                         
  virtual bool to_expr(const std::string &code, exprt &expr,
                       std::ostream &err,
                       const contextt &context,
                       const sequentt &sequent);
                       
  virtual languaget *new_language()
   { return new smv_languaget; }
     
  smv_parset smv_parse;
 };

languaget *new_smv_language();
 
#endif
