/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#include "smv_language.h"
#include "trfalse.h"
#include "smv_typecheck.h"
#include "expr2smv.h"
#include "smv_parser.h"

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool smv_languaget::parse(std::istream &instream,
                          const std::string &path,
                          std::ostream &err)
 {
  smv_parser.clear();

  smv_parset::modulet main_module;
  main_module.name="main";

  smv_parser.line_no=1;
  smv_parser.filename=path;
  smv_parser.in=&instream;
  smv_parser.err=&err;
  smv_parser.parse.modules.push_back(main_module);
  smv_parser.module=&smv_parser.parse.modules.back();

  bool result=yysmvparse();

  smv_parse.swap(smv_parser.parse);

  smv_parser.clear();

  return result;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void smv_languaget::dependancies(std::set<std::string> &module_set)
 {
  #if 0
  forall_modules(it, modules)
    forall_irep(it2, it->statements.get_sub())
     {
      if(it2->id=="inst")
        module_set.insert(verilog_module_symbol(it2->get("module")));
     }
  #endif
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

void smv_languaget::modules_provided(std::set<std::string> &module_set)
 {
  for(smv_parset::modulest::const_iterator it=smv_parse.modules.begin();
      it!=smv_parse.modules.end(); it++)
    module_set.insert(smv_module_symbol(it->name));
 }

/*******************************************************************\

Function: smv_languaget::typecheck

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool smv_languaget::typecheck(contextt &context, std::ostream &err)
 {
  return smv_typecheck(smv_parse, context, err);
 }

/*******************************************************************\

Function: smv_languaget::show_parse

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/
  
void smv_languaget::show_parse()
 {
  for(smv_parset::modulest::const_iterator it=smv_parse.modules.begin();
      it!=smv_parse.modules.end(); it++)
   {
    const smv_parset::modulet &module=*it;
    std::cout << "Module: " << module.name << std::endl << std::endl;

    std::cout << "  VARIABLES: " << std::endl;

    for(smv_parset::mc_varst::const_iterator it=module.vars.begin();
        it!=module.vars.end(); it++)
     {
      std::cout << "    " << it->first << ": ";

      switch(it->second.type)
       {
       case smv_parset::mc_vart::ARRAY:
        std::cout << " ARRAY "
                  << it->second.offset << ".."
                  << it->second.size-it->second.offset-1;
        break;

       case smv_parset::mc_vart::BOOL:
        std::cout << " bool";
        break;

       case smv_parset::mc_vart::RANGE:
        std::cout << "TODO: RANGE";
        break;
       }

      std::cout << std::endl;
     }

    std::cout << endl;

    std::cout << "  SPEC:" << std::endl;
    forall_expr_list(it, module.spec) std::cout << *it << endl << endl;
    std::cout << endl;

    std::cout << "  INIT:" << endl;
    forall_expr_list(it, module.init) std::cout << *it << endl << endl;
    std::cout << endl;

    std::cout << "  TRANS:" << endl;
    forall_expr_list(it, module.trans) std::cout << *it << endl << endl;
    std::cout << endl;

    std::cout << "  DEFINE:" << endl;
    forall_expr_list(it, module.define) std::cout << *it << endl << endl;
    std::cout << endl;

    std::cout << "  INVAR:" << endl;
    forall_expr_list(it, module.invar) std::cout << *it << endl << endl;
    std::cout << endl;

    std::cout << "  FAIRNESS:" << endl;
    forall_expr_list(it, module.fairness) std::cout << *it << endl << endl;
    std::cout << endl;
   }
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool smv_languaget::from_expr(const exprt &expr, std::string &code,
                              const contextt &context,
                              const sequentt &sequent)
 {
  return expr2smv(expr, code);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

bool smv_languaget::to_expr(const std::string &code, exprt &expr,
                            std::ostream &err,
                            const contextt &context,
                            const sequentt &sequent)
 {
  err << "not yet implemented" << std::endl;
  return TRUE;  
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/
  
languaget *new_smv_language()
 {
  return new smv_languaget;
 }

