%{
#include <stdio.h>
#include <string.h>

#define PARSER smv_parser
#define YYSTYPE unsigned

#include "smv_parser.h"
#include "expr.h"
#include "y.tab.h"

int yysmverror(const std::string &error);

%}

%pointer

%%

"/*"		{
		  int c;

		  for(;;)
		    {
		      while((c = yyinput()) != '*' && c != EOF)
			;

		      if(c == '*')
                        {
			  while((c = yyinput()) == '*')
                            ;

			  if( c == '/' ) break;
                        }

		      if (c == EOF)
                        {
			  yysmverror("EOF in comment");
			  break;
                        }
                    }
                }

"//".*          ;
"--".*          ;

[ \t\n]+	;

"INIT"		return INIT_Token;
"TRANS"		return TRANS_Token;
"SPEC"		return SPEC_Token;
"INVAR"		return INVAR_Token;
"VAR"		return VAR_Token;
"ASSIGN"	return ASSIGN_Token;
"DEFINE"	return DEFINE_Token;
"FAIRNESS"	return FAIRNESS_Token;
"MODULE"	return MODULE_Token;

"AG"		return AG_Token;
"AF"		return AF_Token;
"AX"		return AX_Token;
"next"		return NEXT_Token;
"init"		return init_Token;
"inc"		return INC_Token;
"dec"		return DEC_Token;
"add"		return ADD_Token;
"sub"		return SUB_Token;
"case"		return CASE_Token;
"esac"		return ESAC_Token;
"switch"	return SWITCH_Token;
"array"		return ARRAY_Token;
"of"		return OF_Token;
"boolean"	return BOOLEAN_Token;
".."		return DOTDOT_Token;

[A-Za-z][A-Za-z0-9_-]*	{
                  newstack(yysmvlval);
                  stack(yysmvlval).id=yytext;
		  return STRING_Token;
		}
[0-9][0-9]*	{
                  newstack(yysmvlval);
                  stack(yysmvlval).id=yytext;
		  return NUMBER_Token;
		}

"~"		return NOT_Token;
"!"		return NOT_Token;
"+"		return PLUS_Token;
"#"		return OR_Token;
"|"		return OR_Token;
"&"		return AND_Token;
"->"		return IMPLIES_Token;
"<->"		return EQUIV_Token;
"="		return EQUAL_Token;
"!="		return NOTEQUAL_Token;
":="		return BECOMES_Token;

.		return yytext[0];

%%

int yywrap() { return 1; }
