%{
#include <i2string.h>

#include "smv_parser.h"

#define YYSTYPE unsigned
#define PARSER smv_parser

#include "y.tab.h"

/*------------------------------------------------------------------------*/

#define yylineno yysmvlineno
#define yytext yysmvtext

#define yyerror yysmverror
int yysmverror(const std::string &error);
int yylex();
extern char *yytext;

/*------------------------------------------------------------------------*/

#define mto(x, y) stack(x).move_to_operands(stack(y))

/*******************************************************************\

Function: used_with_next

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

static void used_with_next(const exprt &expr)
 {
  const std::string &identifier=expr.get("identifier");

  if(identifier=="")
   {
    yyerror("expected identifier");
   }
  else
   {
    smv_parset::mc_vart &var=smv_parser.module->vars[identifier];

    var.used_with_next=TRUE;
   }
 }

/*******************************************************************\

Function: mtl

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

static void mtl(expr_listt &list, YYSTYPE &expr)
 {
  exprt tmp;
  list.push_back(tmp);
  list.back().swap(stack(expr));
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

static void init(exprt &expr)
 {
  expr.clear();

  irept &location=expr.add("#location");
  location.set("line", smv_parser.line_no);

  if(smv_parser.filename!="")
    location.set("file", smv_parser.filename);
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

static void init(YYSTYPE &expr)
 {
  newstack(expr);
  init(stack(expr));
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

static void init(YYSTYPE &expr, const std::string &id)
 {
  init(expr);
  stack(expr).id=id;
 }

/*******************************************************************\

Function:

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

static void mk_index(YYSTYPE &dest, YYSTYPE &op, YYSTYPE &index)
 {
  init(dest, "extractbit");
  stack(dest).set("index", stack(index));
  mto(dest, op);
 }

/*------------------------------------------------------------------------*/

%}

%token AND_Token OR_Token NOT_Token EQUIV_Token IMPLIES_Token EQUAL_Token
%token NOTEQUAL_Token

%token AG_Token AX_Token AF_Token

%token INIT_Token TRANS_Token SPEC_Token VAR_Token DEFINE_Token ASSIGN_Token
%token INVAR_Token FAIRNESS_Token MODULE_Token ARRAY_Token OF_Token
%token DOTDOT_Token BOOLEAN_Token

%token NEXT_Token INC_Token DEC_Token CASE_Token ESAC_Token BECOMES_Token
%token ADD_Token SUB_Token SWITCH_Token init_Token PLUS_Token

%token STRING_Token
%token NUMBER_Token

%left PLUS_Token

%%

start      : modules
           | formula { mtl(smv_parser.module->spec, $1); }
           ;

modules    : module
           | modules module
           ;

module     : module_head sections
           ;

module_head: MODULE_Token STRING_Token
              {
               smv_parset::modulet module;
               module.name=stack($2).id;

               if(module.name=="main")
                 smv_parser.module=&smv_parser.parse.modules.front();
               else
                {
                 smv_parser.parse.modules.push_back(module);
                 smv_parser.module=&smv_parser.parse.modules.back();
                }
              }
           ;

sections   : /* epsilon */
           | section sections
           ;

section    : VAR_Token vardecls
           | INIT_Token formula     { mtl(smv_parser.module->init, $2); }
           | TRANS_Token formula    { mtl(smv_parser.module->trans, $2); }
           | SPEC_Token formula     { mtl(smv_parser.module->spec, $2); }
           | ASSIGN_Token assignments
           | DEFINE_Token defines
           | INVAR_Token formula    { mtl(smv_parser.module->invar, $2); }
           | FAIRNESS_Token formula { mtl(smv_parser.module->fairness, $2); }
           ;

vardecls   : vardecl
           | vardecl vardecls
           ;

vardecl    : variable_name '[' NUMBER_Token ']'
{
  const std::string &identifier=stack($1).get("identifier");
  smv_parset::mc_vart &var=smv_parser.module->vars[identifier];
  int size=atoi(stack($3).id.c_str());

  if(var.declared)
   {
    yyerror("variable `"+identifier+"' already declared");
    YYERROR;
   }
  else if(size <= 0)
   {
    yyerror("array `"+stack($1).id+"' must have length greater than 0");
    YYERROR;
   }
  else
   {
    var.type=smv_parset::mc_vart::ARRAY;
    var.size=size;
    var.offset=0;
    var.declared=TRUE;
   }
}
           | variable_name ':' ARRAY_Token NUMBER_Token DOTDOT_Token NUMBER_Token
             OF_Token BOOLEAN_Token ';'
{
  const std::string &identifier=stack($1).get("identifier");
  smv_parset::mc_vart &var=smv_parser.module->vars[identifier];
  int start=atoi(stack($4).id.c_str());
  int end=atoi(stack($6).id.c_str());

  if(var.declared)
   {
    yyerror("variable `"+identifier+"' already declared");
    YYERROR;
   }
  else if(start != 0)
   {
    yyerror("array has to start at `0'");
    YYERROR;
   }
  else if(end < start)
   {
    yyerror("array must end with number >= `"+i2string(start)+"'");
    YYERROR;
   }
  else
   {
    var.type=smv_parset::mc_vart::ARRAY;
    var.size=end-start+1;
    var.offset=start;
    var.declared=TRUE;
   }
}
           | variable_name ':' BOOLEAN_Token ';'
{
  const std::string &identifier=stack($1).get("identifier");
  smv_parset::mc_vart &var=smv_parser.module->vars[identifier];

  if(var.declared)
   {
    yyerror("variable `"+identifier+"' already declared");
    YYERROR;
   }
  else
   {
    var.type=smv_parset::mc_vart::BOOL;
    var.size=1;
    var.declared=TRUE;
   }
}
           ;

assignments: assignment
           | assignment assignments
           ;

assignment : assignment_head  '(' assignment_var ')' BECOMES_Token formula ';'
{
  init($$, "=");
  mto($$, $3);
  mto($$, $6);

  if(stack($1).id=="next")
   {
    exprt &op=stack($$).operands()[0];

    if(op.id=="index")
     {
      if(op.operands().size()==1 && op.operands()[0].id=="symbol")
       {
        op.operands()[0].id="next_symbol";
        used_with_next(op.operands()[0]);
       }
      else
        yyerror("unexpected assignment operand");
     }
    else if(op.id=="symbol")
     {
      op.id="next_symbol";
      used_with_next(op);
     }
    else
      yyerror("unexpected assignment operand");

    mtl(smv_parser.module->trans, $$);
   }
  else
    mtl(smv_parser.module->init, $$);
}
;

assignment_var: variable_name
              | variable_name '[' NUMBER_Token ']' { mk_index($$, $1, $3); }
              ;

assignment_head: init_Token { init($$, "init"); }
               | NEXT_Token { init($$, "next"); }
               ;

defines: define
       | define defines
       ;

define : assignment_var BECOMES_Token formula ';'
{
  init($$, "=");
  mto($$, $1);
  mto($$, $3);

  mtl(smv_parser.module->define, $$);
}
;

formula : equiv
        ;

equiv: ors EQUIV_Token ors { init($$, "="); mto($$, $1); mto($$, $3); }
     | ors IMPLIES_Token ors { init($$, "=>"); mto($$, $1); mto($$, $3); }
     | ors
     ;

ors  : ands OR_Token ors { init($$, "or"); stack($$).operands().reserve(2); mto($$, $1); mto($$, $3); }
     | ands
     ;

ands : unary AND_Token ands { init($$, "and"); stack($$).operands().reserve(2); mto($$, $1); mto($$, $3); }
     | unary
     ;

unary: NOT_Token unary { init($$, "not"); mto($$, $2); }
     | AX_Token unary { init($$, "AX"); mto($$, $2); }
     | AF_Token unary { init($$, "AF"); mto($$, $2); }
     | AG_Token unary { init($$, "AG"); mto($$, $2); }
     | basic
     ;

basic: term
     | term EQUAL_Token term { init($$, "="); mto($$, $1); mto($$, $3); }
     | term NOTEQUAL_Token term { init($$, "notequal"); mto($$, $1); mto($$, $3); }
     ;

term: variable_name
    | NEXT_Token '(' variable_name ')' { $$=$3; stack($$).id="next_symbol"; used_with_next(stack($$)); }
    | variable_name '[' NUMBER_Token ']' { mk_index($$, $1, $3); }
    | NEXT_Token '(' variable_name '[' NUMBER_Token ']' ')' { stack($3).id="next_symbol"; used_with_next(stack($$)); mk_index($$, $3, $5); }
    | '(' formula ')' { $$=$2; }
    | INC_Token '(' term ')' { init($$, "inc"); mto($$, $3); }
    | DEC_Token '(' term ')' { init($$, "dec"); mto($$, $3); }
    | term PLUS_Token term { init($$, "+"); mto($$, $1); mto($$, $3); }
    | ADD_Token '(' term ',' term ')' { init($$, "+"); mto($$, $3); mto($$, $5); }
    | SUB_Token '(' term ',' term ')' { init($$, "-"); mto($$, $3); mto($$, $5); }
    | NUMBER_Token { init($$, "constant"); stack($$).set("value", stack($1).id); }
    | CASE_Token cases ESAC_Token { $$=$2; }
    | SWITCH_Token '(' variable_name ')' '{' switches '}' { init($$, "switch"); mto($$, $3); mto($$, $6); }
    ;

variable_name: STRING_Token
		{ init($$, "symbol");
                  stack($$).set("identifier", stack($1).id);
                  smv_parser.module->vars[stack($1).id]; }
             ;

cases   : case ';' { init($$, "cond"); mto($$, $1); }
        | cases ';' case { $$=$1; mto($$, $3); }
        ;

case    : formula ':' term { init($$, "case"); mto($$, $1); mto($$, $3); }
        ;

switches: switch ';' { init($$, "switches"); mto($$, $1); }
        | switches ';' switch { $$=$1; mto($$, $3); }
        ;

switch  : NUMBER_Token ':' term { init($$, "switch"); mto($$, $1); mto($$, $3); }
        ;

%%

int yysmverror(const std::string &error)
{
  (*smv_parser.err) << smv_parser.filename
                    << " line " << smv_parser.line_no
                    << ": "
                    << error
                    << " before `" << yytext << "'\n";

  return 0;
}

#undef yyerror

