/*******************************************************************\

Module: Main Module 

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

/*

  Purpose: Main Module, Command Line Parsing

*/

#include <fstream>
#include <iostream>

#include <parseoptions.h>
#include <smvlang/smv_language.h>

#include "convert.h"

class parseoptionst:public parseoptions_baset
 {
 public:
  virtual int doit();
  virtual void help();
  parseoptionst():parseoptions_baset("(cnf)(dnf)(substitution)") { }
 };

/*******************************************************************\

Function: parseoptionst::doit

  Inputs:

 Outputs:

 Purpose: invoke main modules

\*******************************************************************/

int parseoptionst::doit()
 {
  if(cmdline.args.size()==0)
   {
    std::cerr << "no input files" << std::endl;
    help();
    return 1;
   }

  smv_languaget smv_language;
  contextt context;

  for(unsigned i=0; i<cmdline.args.size(); i++)
   {
    std::cerr << "Parsing " << cmdline.args[i] << std::endl;

    std::ifstream infile(cmdline.args[i].c_str());

    if(smv_language.parse(infile, cmdline.args[i], std::cerr))
      return 1;

    std::cerr << "Type checking" << std::endl;

    if(smv_language.typecheck(context, std::cerr))
      return 2;
   }

  smv_parset::modulet &main=smv_language.smv_parse.modules.front();

  Forall_expr_list(it, main.spec)
   {
    convert(*it, cmdline.isset("dnf"), cmdline.isset("substitution"));
    break;
   }

  return 0;
 }

/*******************************************************************\

Function: parseoptionst::help

  Inputs:

 Outputs:

 Purpose: display command line help

\*******************************************************************/

void parseoptionst::help()
 {
  std::cout <<
    "\n"
    "* *                  15-398 - Problem 1                     * *\n"
    "* * Carnegie Mellon University, Computer Science Department * *\n"
    "\n"
    "Usage:                       Purpose:\n"
    "\n"
    " problem1 [-?] [-h] [--help]  show help\n"
    " problem1 file ...            source file names\n"
    "\n"
    "Additional options:\n"
    " --dnf                        convert to DNF instead of CNF\n"
    " --subsitution                convert using substitution\n"
    "\n";  
 }

/*******************************************************************\

Function: main

  Inputs:

 Outputs:

 Purpose:

\*******************************************************************/

int main(int argc, char **argv)
 {
  parseoptionst parseoptions;

  return parseoptions.parseoptions(argc, argv);
 }
