package comms.dir;

import comms.core.CommsInputStream;
import comms.core.CommsOutputStream;
import java.util.Vector;
import java.util.StringTokenizer;
import java.io.IOException;
import java.net.Socket;

/*****************************************************************************
 * <! Copyright 2000, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: SocketHandler.java 
 * >
 *
 * Thread that services individual clients in the Directory Server.
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  $Revision: 1.1.2.2 $ $Date: 2000/05/10 09:58:45 $
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: SocketHandler.java,v $
 * Revision 1.1.2.2  2000/05/10 09:58:45  telamon
 * new directory server
 *
 *
 * >
 ****************************************************************************/
class SocketHandler extends Thread {
  private Socket socket;
  private Directory dir;
  private CommsInputStream inStream;
  private CommsOutputStream outStream;
  
  SocketHandler(Directory dir, Socket socket) throws IOException {
    this.dir = dir;
    this.socket = socket;
    try {
      inStream = new CommsInputStream(this.socket.getInputStream());
      outStream = new CommsOutputStream(this.socket.getOutputStream());
    } catch (IOException ioe) {
      if (inStream != null) {
	try {
	  inStream.close();
	} catch (IOException ioe2) {  
	}
      }
      try {
	socket.close();
      } catch (IOException ioe3) {
      }
      throw ioe;
    }
  }

  public void run () {
    String vals[];
    String entity;
    String request;
    boolean keepRunning = true;
    while (keepRunning) {
      try {
	vals = inStream.readMessage(); 
	entity = vals[0];
	vals = inStream.readMessage();
	request = vals[0];
	dir.handleRequest (entity, request, inStream, outStream);
      } catch(IllegalArgumentException iae) {
	iae.printStackTrace ();
	System.out.println("Received an illegal phone number string... continuing.");
      } catch(IOException ioe) {
	//ioe.printStackTrace();
	try {
	  socket.close();
	} catch (IOException ioe2) {}
	keepRunning = false;
      }
    }
  }
}
