package comms.dir;

import comms.core.PhoneEntry;

/*****************************************************************************
 * <! Copyright 2000, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: DirectoryViewCon.java 
 * >
 *
 * View/Controller interface for Directory Server model.
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  $Revision: 1.1.2.1 $ $Date: 2000/05/10 09:58:43 $
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: DirectoryViewCon.java,v $
 * Revision 1.1.2.1  2000/05/10 09:58:43  telamon
 * new directory server
 *
 * 
 * >
 ****************************************************************************/
interface DirectoryViewCon {
  
  /**
   * Called by Directory when done initializing
   */
  public void initialized();
  
  /**
   * Called by Directory after an entry is added to the listing
   */
  public void entryAdded(PhoneEntry pe);

  /**
   * Called by Directory after an entry is removed from the listing
   */
  public void entryRemoved(PhoneEntry pe);

  /**
   * Called by Directory when the list is reset
   */
  public void reset();
  
}
