package comms.core;
/**
  * @author Jeffrey Lam <Odin@CMU.edu>
  *
  */

import java.io.IOException;
import java.net.*;

public class ServerThread extends Thread {
  private CommsServer server;
  private ConnectionTable connectionTable;
  private QueueAssign qAssign;
  private String lastConnectionName; // name of most recent connection thread

  public ServerThread(int port, ConnectionTable c, QueueAssign qa) 
    throws IOException {

      server = new CommsServer(port);
      connectionTable = c;
      qAssign = qa;
      System.out.println(server);
      System.out.println(c);
  }

  public ServerThread(ConnectionTable c, QueueAssign qa) throws IOException {
    connectionTable = c;
    qAssign = qa;
    server = new CommsServer();
  }

  public ConnectionTable getConnectionTable() {
    return connectionTable;
  }

  public String getLastConnectionName() {
    return lastConnectionName;
  }

  public int getLocalPort() {
    return server.getLocalPort();
  }

  public String getHostname() throws UnknownHostException {
    return LocalHost.getFullLocalHostName();
  }

  public void run() {
    while (true) {
      try {
	CommsStream cs = server.acceptConnection();

	// this must be where the name gets missing in java directory server
	lastConnectionName = cs.readMessage().getMessage();

	// An accidentally terminated connection thread should've stopped
	// itself (see ConnectionThread.run()) already, so there's no need
	// to look it up in the connection table.
	Connection c = new Connection(lastConnectionName,
				      cs,
				      qAssign.getQueue(lastConnectionName),
				      qAssign);
	connectionTable.addConnection(c);
	c.start();
      } catch (Exception e) {
	//e.printStackTrace();
      }
    }
  }

  public void close() {
    try {
      server.close();
    }
    catch (IOException ioe) {
    }
  }
  
  protected void finalize() throws Throwable {
    server = null;
    connectionTable = null;
    qAssign = null;
    lastConnectionName = null;
    super.finalize();
  }
}
