package comms.core;

import java.util.Hashtable;

public class QueueAssign {
  private Hashtable queueTable;
  private MessageQueue defaultQueue;

  public QueueAssign(MessageQueue def) {
    queueTable = new Hashtable();
    defaultQueue = def;
  }

  public MessageQueue getQueue(String name) {
    Object retVal = null;
    QueueAssignNode retNode = (QueueAssignNode) queueTable.get(name);
    if(retNode == null) {
      retVal = defaultQueue;
    }
    else {
      retVal = retNode.getQueue();
    }
    return (MessageQueue) retVal;
  }
  
  public void setQueue(String name, MessageQueue mq) {
    setQueue(name, mq, false);
  }

  public void setQueue(String name, MessageQueue mq, boolean rev) {
    QueueAssignNode newNode = new QueueAssignNode(mq,rev);
    queueTable.put(name,newNode);
  }

  public void unsetQueue(String name) {
    queueTable.remove(name);
  }

  public boolean revert(String name) {
    QueueAssignNode retNode = (QueueAssignNode) queueTable.get(name);
    if(retNode != null) {
      if(retNode.getRevert()) {
	//revertable so remove it from the QueueAssign table
	unsetQueue(name);
        return true;        
      }
    }
    return false;    
  }
}


