/**
  * @author Jeffrey Lam <Odin@CMU.edu>
  *
  */

package comms.core;

import java.io.IOException;
import java.util.*;

public class PhoneTable extends Hashtable implements PhoneCodes{

  // we need to save directory server info for later...when we call
  // getPhoneNumber()
  private String directoryHostname;
  private int directoryPort;

  PhoneTable() {
    super();
  }

  /** connects to directory and gets info */
  public PhoneTable(PhoneEntry p, String host, int port) 
    throws IOException {

      //Thread.yield();
      directoryHostname = host;
      directoryPort = port;
      CommsStream directoryStream = new CommsStream(host, port);
      //System.out.println("directoryStream: "+directoryStream);

      //directoryStream.sendMessage(p.getName());
      directoryStream.sendMessage(p.getName());
      //System.out.println("p.getName(): "+p.getName());
      directoryStream.sendMessage(REGISTER);
      directoryStream.sendMessage(p.getPhoneNumber().toString());
      //System.out.println("phoneNumber: "+p.getPhoneNumber().toString());

      /*directoryStream.sendMessage(p.getName()+" "+REGISTER+" "+
				  p.getPhoneNumber().toString());*/

      for (String message = directoryStream.readMessage().getMessage();
	   !message.equals(DONE);
	   message = directoryStream.readMessage().getMessage()) {

	//System.out.println("message in for loop: "+message);
	// parse message
	StringTokenizer messageLine = new StringTokenizer(message);
	String name = messageLine.nextToken();
	String hostname = messageLine.nextToken();
	int portParsed = Integer.parseInt(messageLine.nextToken());

	/*System.out.println("message tokenized: "+name+" "+hostname+" "+
			   portParsed);*/
	addEntry(name, new PhoneNumber(hostname, portParsed));
      }
      System.out.println("closing directory stream");
      directoryStream.close();
  }

  public void addEntry(PhoneEntry p) {
    put(p.getName(), p.getPhoneNumber());
  }

  public void addEntry(String name, PhoneNumber p) {
    put(name, p);
  }

  public PhoneEntry getEntry(String name) throws IOException,
    NoPhoneNumberException {

    return new PhoneEntry(name, getPhoneNumber(name));
  }

  public String getDirectoryHostname() {
	 return directoryHostname;
  }

  public int getDirectoryPort() {
	 return directoryPort;
  }

  public PhoneNumber getPhoneNumber(String name) throws IOException,
    NoPhoneNumberException {

    PhoneNumber temp = (PhoneNumber) super.get(name);

    // connect to directory server if phone number can't be found locally
    if (temp == null) {
      CommsStream directoryStream = new CommsStream(directoryHostname,
						    directoryPort);
      directoryStream.sendMessage(name);
      directoryStream.sendMessage("match");
      String hostAndPort = null;

      // what if the phone entry is not even in directory server?
      /*try {
	hostAndPort = directoryStream.readMessage().getMessage();
      } catch (NullPointerException n) {
	throw new NoPhoneNumberException();
      } catch (Exception e) {
	e.printStackTrace();
      }*/
      hostAndPort = directoryStream.readMessage().getMessage();

      System.out.println("closing directory stream");
      directoryStream.close();

      if (hostAndPort.equals("fail")) {	
	throw new NoPhoneNumberException();
      }

      System.out.println("hostAndPort: "+hostAndPort);
      StringTokenizer hostAndPortTokens = new StringTokenizer(hostAndPort);
      String clientName = hostAndPortTokens.nextToken();
      String host = hostAndPortTokens.nextToken();
      System.out.println("getPhoneNumber() host: "+host);
      String portString = hostAndPortTokens.nextToken();
      System.out.println("getPhoneNumber() port: "+portString);
      int port = Integer.parseInt(portString);
      temp = new PhoneNumber(host, port);
      addEntry(name, temp);
    }
    return temp;
  }

  void init(PhoneEntry p, String host, int port) {
    if (host.equals(null)) {
      return;
    }
  }

  protected void finalize() throws Throwable {
    //directoryStream = null;
    directoryHostname = null;
    super.finalize();
  }
}
