package comms.core;

import java.util.StringTokenizer;

/**
 *  
 */
public class PhoneNumber
{
  /** The IP address of the phone number (eg "128.2.111.159"). */
  public String IPAddress;

  /** The port of the phone number. */
  public int port;

  /** Creates a new phone number. */
  public PhoneNumber(String IPAddress, int port)
  {
    this.IPAddress = IPAddress;
    this.port = port;
  }

  public String getHostname() {
    return IPAddress;
  }

  public int getPortNumber() {
    return port;
  }

  /** Test to make sure parsing works. */
  public static void main(String argv[])
  {
    PhoneNumber pn = new PhoneNumber("128.2.111.155", 6543);
    System.out.println("Original: "+pn);
    try
    {
      PhoneNumber newPn = parsePhoneNumber(pn.toString());
      System.out.println("Parsed: "+newPn);
    }
    catch(IllegalArgumentException e) { System.out.println("Parsing failed."); System.exit(-1); }
  }

  /**
   *  Creates a new phone number from a given string. The format would look
   *  like the following: "128.2.111.159 6550"
   *
   *@return a new PhoneNumber created from the given string.
   */
  public static PhoneNumber parsePhoneNumber(String phoneNumberId) throws IllegalArgumentException
  {
    StringTokenizer strtok = new StringTokenizer(phoneNumberId);
    if(strtok.countTokens() != 2)
      throw new IllegalArgumentException("Too many words in string \""+phoneNumberId+"\"");
    String phoneNumberIPAddress = strtok.nextToken();
    String phoneNumberPort = strtok.nextToken();
    try{ return new PhoneNumber(phoneNumberIPAddress, Integer.parseInt(phoneNumberPort)); }
    catch(NumberFormatException e) { throw new IllegalArgumentException("Unable to understand port number: "+phoneNumberPort); }
  }

  /** A string representation of a phone number. */
  public String toString()
  { return new String(IPAddress+' '+port); }

  public boolean valid() {
    if(IPAddress == null || IPAddress.indexOf(' ') != -1) {
      return false;
    }
    return true;
  }
}
