package comms.core;

/**
  * @author Jeffrey Lam <Odin@CMU.edu>
  *
  */

import java.util.*;

public class MessageQueue extends Queue {

  private final static boolean debug = false;

  //private boolean keepMessages; // tells the message queue whether or not to
  // keep the queued messages for message logging
  //private int elementNumber; // keeps track of which element would have been
  // at the top of the queue

  /*public MessageQueue() {

  }

  public MessageQueue(boolean k) {
    keepMessages = k;
  }*/

  public synchronized void add(Message message) {
    super.queueIn(message);
    if (elementCount == 1) {
    //if ((elementCount - elementNumber) == 1) {
      this.notify();
    }
  }

  /*public boolean isKeepingMessages() {
    return keepMessages;
  }*/

  public synchronized Message remove() {
    /*try {
      if (keepMessages == false) {
	return (Message) super.queueOut();
      } else {
	return (Message) super.elementAt(++elementNumber - 1);
      }
    } catch (EmptyQueueException e) {
      return null;
    } catch (ArrayIndexOutOfBoundsException a) {
      //a.printStackTrace();
      elementNumber--; // Does elementAt() throw the exception before or after
      // elementNumber has been incremented ?
      return null;
    }*/

    try {
      return (Message) super.queueOut();
    } catch (EmptyQueueException e) {
      return null;
    }
  }

  public synchronized boolean waitForMessage() {
    if(debug) {
      System.out.println("MessageQueue.waitForMessage()");
    }
    boolean blocked = false;
    while(this.elementCount == 0) {
      if (debug) {
	System.out.println("waitForMessage() while-loop");
      }
      //while (elementCount == elementNumber) {
      blocked = true;
      try {
	this.wait();
      } catch (Exception e) {
	e.printStackTrace();
      }
    }
    if(debug) {
      System.out.println("end of MessageQueue.waitForMessage()");
    }
    return blocked;
  }

  protected void finalize() throws Throwable {
    super.finalize();
  }
}
