package comms.core;

/**
  * @author Jeffrey Lam <Odin@CMU.edu>
  *
  */

import java.util.Date;

public class Message {
  public static final String kUNKNOWN = "X";
  
  private String message,
    correspondent,
    sender,
    recipient;

  private Date time; // timestamp of when message was sent or received

  public Message(String m, String to, String from) {
    setTimeStamp();
    // trim off the extra null character that was necessary for interaction
    // with the C++ client/servers
    /**** We just want to get rid of the last null char introduced by the
	  C++ side. For certain messages (i.e. mapping) we need to receive
	  the null chars at the end of the message. i.e. the last 6 spots 
	  of the map message might be less that \u0020 and we need to 
	  preserve them.
    message = m.trim();
    */
    /*Use this instead */
    /*
      if( m.charAt(m.length()-1) == '\u0000') {
      message = m.substring(0,m.length()-1);
      }
      else {
    */
    message = m;
      /*}*/
    recipient = to;
    sender = from;
  }
  
  public Message(String m) {
    this(m,null,null);
  }
  
  public String getCorrespondent() {
    return correspondent;
  }
  
  public String getTo() {
    return recipient;
  }
  
  public String getFrom() {
    return sender;
  }
  
  public int getLength() {
    return message.length();
  }
  
  public String getMessage() {
    return message;
  }
  
  public Date getTimeStamp() {
    return time;
  }
  
  public void setCorrespondent(String c) {
    correspondent = c;
  }
  
  public void setTo(String c) {
    recipient = c;
  }
  
  public void setFrom(String c) {
    sender = c;
  }
  
  public void setMessage(String m) {
    message = m;
  }
  
  public void setTimeStamp() {
    time = new Date();
  }
  
  protected void finalize() throws Throwable {
    message = null;
    time = null;
    super.finalize();
  }
}
