/**
  * @author Jeffrey Lam <Odin@CMU.edu>
  *
  */

package comms.core;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;

public class LogThread extends Thread {

  private MessageQueue sent, received;
  Date upTime;

  public LogThread(String host, Date u, MessageQueue s, MessageQueue r) {
    super(host+".log");
    upTime = u;
    sent = s;
    received = r;
    super.setDaemon(true);
    super.setPriority(MIN_PRIORITY);
  }

  public void run() {
    try {
      PrintWriter logfile =
	new PrintWriter(new BufferedWriter(new FileWriter(super.getName())),
			true);
      SimpleDateFormat date = 
	new SimpleDateFormat("MMM dd, yyyy HH:mm:ss:SSS z");
      System.out.println(date.format(upTime));
      logfile.println(date.format(upTime));
      long time1 = upTime.getTime();

      while (true) {
	try {
	  Thread.sleep(5000);
	  //Thread.yield();
	  //System.out.println("LogThread.run(), in while loop");
	  //System.out.println(sent);
	  //System.out.println(received);
	  //System.out.println("sent.waitForMessage() "+sent.waitForMessage());
	  //System.out.println(received.waitForMessage());
	  //System.out.println("LogThread.run(), done waiting for messages");

	  Message sentMessage, receiveMessage;
	  try {
	    sentMessage = (Message) sent.firstElement();
	  } catch (NoSuchElementException n) {
	    sentMessage = null;
	  }
	  try {
	    receiveMessage = (Message) received.firstElement();
	  } catch (NoSuchElementException n) {
	    receiveMessage = null;
	  }
	  //System.out.println(sentMessage);
	  //System.out.println(receiveMessage);
	  if ((sentMessage == null) && (receiveMessage == null)) {
	    //System.out.println("both null");
	    continue;
	  }

	  if ((sentMessage != null) && (receiveMessage == null)) {
	    Date sentDate = sentMessage.getTimeStamp();
	    long sentTime = sentDate.getTime();
	    /*System.out.println("+"+(sentTime - time1)+"ms "+
			       date.format(sentDate)+" to "+
			       sentMessage.getCorrespondent()+" \""+
			       sentMessage.getMessage()+"\"");*/
	    logfile.println("+"+(sentTime - time1)+"ms "+
			    date.format(sentDate)+" to "+
			    sentMessage.getCorrespondent()+" \""+
			    sentMessage.getMessage()+"\"");
	    sent.remove();
	    time1 = sentTime;
	  } else if ((receiveMessage != null) && (sentMessage == null)) {
	    Date receiveDate = receiveMessage.getTimeStamp();
	    long receiveTime = receiveDate.getTime();
	    /*System.out.println("+"+(receiveTime - time1)+"ms "+
			       date.format(receiveDate)+" from "+
			       receiveMessage.getCorrespondent()+" \""+
			       receiveMessage.getMessage()+"\"");*/
	    logfile.println("+"+(receiveTime - time1)+"ms "+
			    date.format(receiveDate)+" from "+
			    receiveMessage.getCorrespondent()+" \""+
			    receiveMessage.getMessage()+"\"");
	    received.remove();
	    time1 = receiveTime;
	  } else {
	    Date sentDate = sentMessage.getTimeStamp(),
	      receiveDate = receiveMessage.getTimeStamp();
	    long sentTime = sentDate.getTime(),
	      receiveTime = receiveDate.getTime();

	    if (sentTime < receiveTime) {
	      /*System.out.println("+"+(sentTime - time1)+"ms "+
				 date.format(sentDate)+" to "+
				 sentMessage.getCorrespondent()+" \""+
				 sentMessage.getMessage()+"\"");*/
	      logfile.println("+"+(sentTime - time1)+"ms "+
			      date.format(sentDate)+" to "+
			      sentMessage.getCorrespondent()+" \""+
			      sentMessage.getMessage()+"\"");
	      sent.remove();
	      time1 = sentTime;
	    } else {
	      /*System.out.println("+"+(receiveTime - time1)+"ms "+
				 date.format(receiveDate)+" from "+
				 receiveMessage.getCorrespondent()+" \""+
				 receiveMessage.getMessage()+"\"");*/
	      logfile.println("+"+(receiveTime - time1)+"ms "+
			      date.format(receiveDate)+" from "+
			      receiveMessage.getCorrespondent()+" \""+
			      receiveMessage.getMessage()+"\"");
	      received.remove();
	      time1 = receiveTime;
	    }
	  }
	} catch (Exception e) {
	  e.printStackTrace();
	}
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void finalize() throws Throwable {
    sent = received = null;
    upTime = null;
    super.finalize();
  }
}
