package comms.core;

import java.net.*;

/*****************************************************************************
 * <! Copyright 1998, Institute for Complex Engineered Sytems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: LocalHost.java 
 * >
 *
 * This is a workaround for inconsistencies in
 * <code>InetAddress.getLocalHost().getHostName()</code> on
 * Win32 and Linux.
 *
 * Under Win32, that call returns a simple hostname.
 * i.e. recondelta
 * Under Linux, that call returns a full hostname.
 * i.e. recondelta.ius.cs.cmu.edu
 *
 * By calling the static method, <code>LocalHost.getFullLocalHostName()</code>
 * you will always get the full hostname in lowercase letters.
 * i.e. recondelta.ius.cs.cmu.edu
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  1.00 2/19/98<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: LocalHost.java,v $
 * Revision 1.1.2.1  1999/07/23 19:21:59  telamon
 * changed code to use comms.core.LocalHost when looking up hostname
 *
 * Revision 1.1  1999/07/22 17:21:18  telamon
 * moved LocalHost.java to comms/core
 *
 * Revision 1.1  1999/03/02 21:34:54  telamon
 * added localhost java fix
 *
 * Revision 1.1  1999/02/22 01:51:41  telamon
 * first localhost revision
 *
 * >
 ****************************************************************************/
public abstract class LocalHost {

  
  /***************************************************************************
   *
   * Returns the full local hostname in lowercase letters.
   *
   * @param 
   *
   * @return full local hostname in lowercase letters.
   *
   * @exception UnknownHostException thrown if the hostname cannot be
   *                                 determined
   *
   **************************************************************************/
  public static String getFullLocalHostName() throws UnknownHostException{
    String retVal;
    InetAddress localIP = InetAddress.getLocalHost();
    retVal = InetAddress.getByName(localIP.getHostAddress()).getHostName();
    return retVal.toLowerCase();
  }
}
