package comms.core;

public abstract class EntryTypes {
  public final static int NORMAL = 0;
  public final static String NORMAL_ST = "None";
  public final static int ADAPTABLE_COORDINATOR = NORMAL+1;
  public final static String ADAPTABLE_COORDINATOR_ST = "Adapt_Coord";
  public final static int ADAPTABLE_MODULESERVER = ADAPTABLE_COORDINATOR+1;
  public final static String ADAPTABLE_MODULESERVER_ST = "Adapt_ModServer";
  public final static int MAX_TYPE =  ADAPTABLE_MODULESERVER+1;
  public final static int DEFAULT = NORMAL;
  public final static String DEFAULT_ST = NORMAL_ST;
  
  public static String getTypeString(int type) {
    String retVal = DEFAULT_ST;
    if(type == NORMAL) {
      retVal = NORMAL_ST;
    } else if (type == ADAPTABLE_COORDINATOR) {
      retVal = ADAPTABLE_COORDINATOR_ST;
    } else if (type == ADAPTABLE_MODULESERVER) {
      retVal = ADAPTABLE_MODULESERVER_ST;
    }
    return retVal;
  }
}
