/**
  * @author Jeffrey Lam <Odin@CMU.edu>
  *
  */

package comms.core;

import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class DirectoryServer extends Communications implements PhoneCodes {
    
  public DirectoryServer() throws IOException {
    // don't put spaces in the server name or it'll cause parsing problems
    // later
    super("DirectoryServer");
  }

  public DirectoryServer(String name) throws IOException {
    super(name);
  }

  public DirectoryServer(int localPort) throws IOException {
    super("DirectoryServer", localPort);
  }

  public void addEntry(String name, String host, int port) {
    super.addEntry(new PhoneEntry(name, host, port));
  }

  public void parse() throws Exception {
    // call stopServer() to stop directory server and stop parsing
    while (true) {
      // we should probably make the requester and request into one message
      // to ensure the order of messages in the queue
      //super.waitForMessage();
      /*StringTokenizer requestMessage =
	new StringTokenizer(super.readNextMessage().getMessage());*/
      String requester = super.getLastConnectionName();
      //String requester = requestMessage.nextToken();
      System.out.println("requester: "+requester);
      //super.waitForMessage();
      String request = super.readNextMessage().getMessage();
      //String request = requestMessage.nextToken();
      System.out.println("request: "+request);

      if (request.equals(REGISTER)) {
	super.waitForMessage();
	StringTokenizer hostAndPort =
	  new StringTokenizer(super.readNextMessage().getMessage());
	
	String host = hostAndPort.nextToken();
	//String host = requestMessage.nextToken();
	int port = Integer.parseInt(hostAndPort.nextToken());
	//int port = Integer.parseInt(requestMessage.nextToken());

	// need to add requester's entry before you know where to send the
	// contents to requester
	addEntry(requester, host, port);
	sendContents(requester);
      } else if (request.equals(RETRANSMIT)) {
	sendContents(requester);
      } else if (request.equals(MATCH)) {
	sendEntry(requester);
      } else if (request.equals(REMOVE)) {
	removeEntry(requester);
      } else if (request.equals(DONE)) {
	// close connection with requester
	//super.closeConnection(requester);
      } else {
	System.out.println("message not recognized");
      }
      super.closeConnection(requester);
    }
  }

  public void removeEntry(String name) {
    rolodex.remove(name);
  }

  public void reset() {
   rolodex.clear(); 
  }

  public void sendContents(String receiver) throws IOException {
    for (Enumeration values = rolodex.elements(), keys = rolodex.keys();
	 values.hasMoreElements();) {

      super.sendMessage(receiver,
			new
			Message(((String) keys.nextElement())+" "+
				((PhoneNumber) 
				 values.nextElement()).toString()));
    }
    super.sendMessage(receiver, new Message(DONE));
  }

  public void sendEntry(String receiver, String name) throws IOException {
    try {
      super.sendMessage(receiver, new
			Message(name+" "+
				((PhoneNumber)
				 rolodex.getPhoneNumber(name)).toString()));
    } catch (NullPointerException n) {
      System.out.println("entry not found");
      super.sendMessage(receiver, new Message(FAIL));
    }
  }

  public void sendEntry(String receiver) throws IOException {
    sendEntry(receiver, receiver);
  }

  public static void main(String arg[]) {
    DirectoryServer directoryServer = null;

    try {
      if (arg.length == 0) {
	directoryServer = new DirectoryServer();
      } else if (arg.length == 1) {
	directoryServer = new DirectoryServer(Integer.parseInt(arg[0]));
      } else {
	System.out.println("Argument format error");
      }
      System.out.println("connected at localhost on port " +
			 directoryServer.getLocalPort());
      Thread.yield();
      directoryServer.parse();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void finalize() throws Throwable {
    super.finalize();
  }
}
